@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getControls.
 * @property enabledControls List of all the ARNs for the controls applied to the `target_identifier`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property targetIdentifier
 */
public data class GetControlsResult(
    public val enabledControls: List<String>,
    public val id: String,
    public val targetIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.controltower.outputs.GetControlsResult):
            GetControlsResult = GetControlsResult(
            enabledControls = javaType.enabledControls().map({ args0 -> args0 }),
            id = javaType.id(),
            targetIdentifier = javaType.targetIdentifier(),
        )
    }
}
