@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionSubscriber
import com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpression
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionSubscriber.Companion.toKotlin as anomalySubscriptionSubscriberToKotlin
import com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpression.Companion.toKotlin as anomalySubscriptionThresholdExpressionToKotlin

/**
 * Builder for [AnomalySubscription].
 */
@PulumiTagMarker
public class AnomalySubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnomalySubscriptionArgs = AnomalySubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnomalySubscriptionArgsBuilder.() -> Unit) {
        val builder = AnomalySubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AnomalySubscription {
        val builtJavaResource = com.pulumi.aws.costexplorer.AnomalySubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AnomalySubscription(builtJavaResource)
    }
}

/**
 * Provides a CE Anomaly Subscription.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalyMonitor;
 * import com.pulumi.aws.costexplorer.AnomalyMonitorArgs;
 * import com.pulumi.aws.costexplorer.AnomalySubscription;
 * import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testAnomalyMonitor = new AnomalyMonitor("testAnomalyMonitor", AnomalyMonitorArgs.builder()
 *             .monitorType("DIMENSIONAL")
 *             .monitorDimension("SERVICE")
 *             .build());
 *         var testAnomalySubscription = new AnomalySubscription("testAnomalySubscription", AnomalySubscriptionArgs.builder()
 *             .frequency("DAILY")
 *             .monitorArnLists(testAnomalyMonitor.arn())
 *             .subscribers(AnomalySubscriptionSubscriberArgs.builder()
 *                 .type("EMAIL")
 *                 .address("abc@example.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### For a Specific Dimension
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalySubscription;
 * import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionDimensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AnomalySubscription("test", AnomalySubscriptionArgs.builder()
 *             .frequency("DAILY")
 *             .monitorArnLists(aws_ce_anomaly_monitor.test().arn())
 *             .subscribers(AnomalySubscriptionSubscriberArgs.builder()
 *                 .type("EMAIL")
 *                 .address("abc@example.com")
 *                 .build())
 *             .thresholdExpression(AnomalySubscriptionThresholdExpressionArgs.builder()
 *                 .dimension(AnomalySubscriptionThresholdExpressionDimensionArgs.builder()
 *                     .key("ANOMALY_TOTAL_IMPACT_ABSOLUTE")
 *                     .values("100.0")
 *                     .matchOptions("GREATER_THAN_OR_EQUAL")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using an `and` Expression
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalySubscription;
 * import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AnomalySubscription("test", AnomalySubscriptionArgs.builder()
 *             .frequency("DAILY")
 *             .monitorArnLists(aws_ce_anomaly_monitor.test().arn())
 *             .subscribers(AnomalySubscriptionSubscriberArgs.builder()
 *                 .type("EMAIL")
 *                 .address("abc@example.com")
 *                 .build())
 *             .thresholdExpression(AnomalySubscriptionThresholdExpressionArgs.builder()
 *                 .ands(
 *                     AnomalySubscriptionThresholdExpressionAndArgs.builder()
 *                         .dimension(AnomalySubscriptionThresholdExpressionAndDimensionArgs.builder()
 *                             .key("ANOMALY_TOTAL_IMPACT_ABSOLUTE")
 *                             .matchOptions("GREATER_THAN_OR_EQUAL")
 *                             .values("100")
 *                             .build())
 *                         .build(),
 *                     AnomalySubscriptionThresholdExpressionAndArgs.builder()
 *                         .dimension(AnomalySubscriptionThresholdExpressionAndDimensionArgs.builder()
 *                             .key("ANOMALY_TOTAL_IMPACT_PERCENTAGE")
 *                             .matchOptions("GREATER_THAN_OR_EQUAL")
 *                             .values("50")
 *                             .build())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SNS Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.costexplorer.AnomalyMonitor;
 * import com.pulumi.aws.costexplorer.AnomalyMonitorArgs;
 * import com.pulumi.aws.costexplorer.AnomalySubscription;
 * import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var costAnomalyUpdates = new Topic("costAnomalyUpdates");
 *         final var snsTopicPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .policyId("__default_policy_ID")
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("AWSAnomalyDetectionSNSPublishingPermissions")
 *                     .actions("SNS:Publish")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("costalerts.amazonaws.com")
 *                         .build())
 *                     .resources(costAnomalyUpdates.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("__default_statement_ID")
 *                     .actions(
 *                         "SNS:Subscribe",
 *                         "SNS:SetTopicAttributes",
 *                         "SNS:RemovePermission",
 *                         "SNS:Receive",
 *                         "SNS:Publish",
 *                         "SNS:ListSubscriptionsByTopic",
 *                         "SNS:GetTopicAttributes",
 *                         "SNS:DeleteTopic",
 *                         "SNS:AddPermission")
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("AWS:SourceOwner")
 *                         .values(var_.account-id())
 *                         .build())
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("*")
 *                         .build())
 *                     .resources(costAnomalyUpdates.arn())
 *                     .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(costAnomalyUpdates.arn())
 *             .policy(snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicy -> snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var anomalyMonitor = new AnomalyMonitor("anomalyMonitor", AnomalyMonitorArgs.builder()
 *             .monitorType("DIMENSIONAL")
 *             .monitorDimension("SERVICE")
 *             .build());
 *         var realtimeSubscription = new AnomalySubscription("realtimeSubscription", AnomalySubscriptionArgs.builder()
 *             .frequency("IMMEDIATE")
 *             .monitorArnLists(anomalyMonitor.arn())
 *             .subscribers(AnomalySubscriptionSubscriberArgs.builder()
 *                 .type("SNS")
 *                 .address(costAnomalyUpdates.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(default_)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ce_anomaly_subscription` using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:costexplorer/anomalySubscription:AnomalySubscription example AnomalySubscriptionARN
 * ```
 *
 */
public class AnomalySubscription internal constructor(
    override val javaResource: com.pulumi.aws.costexplorer.AnomalySubscription,
) : KotlinCustomResource(javaResource, AnomalySubscriptionMapper) {
    /**
     * The unique identifier for the AWS account in which the anomaly subscription ought to be created.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * ARN of the anomaly subscription.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The frequency that anomaly reports are sent. Valid Values: `DAILY` | `IMMEDIATE` | `WEEKLY`.
     */
    public val frequency: Output<String>
        get() = javaResource.frequency().applyValue({ args0 -> args0 })

    /**
     * A list of cost anomaly monitors.
     */
    public val monitorArnLists: Output<List<String>>
        get() = javaResource.monitorArnLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name for the subscription.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A subscriber configuration. Multiple subscribers can be defined.
     */
    public val subscribers: Output<List<AnomalySubscriptionSubscriber>>
        get() = javaResource.subscribers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    anomalySubscriptionSubscriberToKotlin(args0)
                })
            })
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * An Expression object used to specify the anomalies that you want to generate alerts for. See Threshold Expression.
     */
    public val thresholdExpression: Output<AnomalySubscriptionThresholdExpression>
        get() = javaResource.thresholdExpression().applyValue({ args0 ->
            args0.let({ args0 ->
                anomalySubscriptionThresholdExpressionToKotlin(args0)
            })
        })
}

public object AnomalySubscriptionMapper : ResourceMapper<AnomalySubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.costexplorer.AnomalySubscription::class == javaResource::class

    override fun map(javaResource: Resource): AnomalySubscription = AnomalySubscription(
        javaResource
            as com.pulumi.aws.costexplorer.AnomalySubscription,
    )
}

/**
 * @see [AnomalySubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AnomalySubscription].
 */
public suspend fun anomalySubscription(
    name: String,
    block: suspend AnomalySubscriptionResourceBuilder.() -> Unit,
): AnomalySubscription {
    val builder = AnomalySubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AnomalySubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun anomalySubscription(name: String): AnomalySubscription {
    val builder = AnomalySubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
