@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs.builder
import com.pulumi.aws.costexplorer.kotlin.inputs.AnomalySubscriptionSubscriberArgs
import com.pulumi.aws.costexplorer.kotlin.inputs.AnomalySubscriptionSubscriberArgsBuilder
import com.pulumi.aws.costexplorer.kotlin.inputs.AnomalySubscriptionThresholdExpressionArgs
import com.pulumi.aws.costexplorer.kotlin.inputs.AnomalySubscriptionThresholdExpressionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CE Anomaly Subscription.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalyMonitor;
 * import com.pulumi.aws.costexplorer.AnomalyMonitorArgs;
 * import com.pulumi.aws.costexplorer.AnomalySubscription;
 * import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testAnomalyMonitor = new AnomalyMonitor("testAnomalyMonitor", AnomalyMonitorArgs.builder()
 *             .monitorType("DIMENSIONAL")
 *             .monitorDimension("SERVICE")
 *             .build());
 *         var testAnomalySubscription = new AnomalySubscription("testAnomalySubscription", AnomalySubscriptionArgs.builder()
 *             .frequency("DAILY")
 *             .monitorArnLists(testAnomalyMonitor.arn())
 *             .subscribers(AnomalySubscriptionSubscriberArgs.builder()
 *                 .type("EMAIL")
 *                 .address("abc@example.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### For a Specific Dimension
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalySubscription;
 * import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionDimensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AnomalySubscription("test", AnomalySubscriptionArgs.builder()
 *             .frequency("DAILY")
 *             .monitorArnLists(aws_ce_anomaly_monitor.test().arn())
 *             .subscribers(AnomalySubscriptionSubscriberArgs.builder()
 *                 .type("EMAIL")
 *                 .address("abc@example.com")
 *                 .build())
 *             .thresholdExpression(AnomalySubscriptionThresholdExpressionArgs.builder()
 *                 .dimension(AnomalySubscriptionThresholdExpressionDimensionArgs.builder()
 *                     .key("ANOMALY_TOTAL_IMPACT_ABSOLUTE")
 *                     .values("100.0")
 *                     .matchOptions("GREATER_THAN_OR_EQUAL")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using an `and` Expression
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalySubscription;
 * import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AnomalySubscription("test", AnomalySubscriptionArgs.builder()
 *             .frequency("DAILY")
 *             .monitorArnLists(aws_ce_anomaly_monitor.test().arn())
 *             .subscribers(AnomalySubscriptionSubscriberArgs.builder()
 *                 .type("EMAIL")
 *                 .address("abc@example.com")
 *                 .build())
 *             .thresholdExpression(AnomalySubscriptionThresholdExpressionArgs.builder()
 *                 .ands(
 *                     AnomalySubscriptionThresholdExpressionAndArgs.builder()
 *                         .dimension(AnomalySubscriptionThresholdExpressionAndDimensionArgs.builder()
 *                             .key("ANOMALY_TOTAL_IMPACT_ABSOLUTE")
 *                             .matchOptions("GREATER_THAN_OR_EQUAL")
 *                             .values("100")
 *                             .build())
 *                         .build(),
 *                     AnomalySubscriptionThresholdExpressionAndArgs.builder()
 *                         .dimension(AnomalySubscriptionThresholdExpressionAndDimensionArgs.builder()
 *                             .key("ANOMALY_TOTAL_IMPACT_PERCENTAGE")
 *                             .matchOptions("GREATER_THAN_OR_EQUAL")
 *                             .values("50")
 *                             .build())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SNS Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.costexplorer.AnomalyMonitor;
 * import com.pulumi.aws.costexplorer.AnomalyMonitorArgs;
 * import com.pulumi.aws.costexplorer.AnomalySubscription;
 * import com.pulumi.aws.costexplorer.AnomalySubscriptionArgs;
 * import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var costAnomalyUpdates = new Topic("costAnomalyUpdates");
 *         final var snsTopicPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .policyId("__default_policy_ID")
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("AWSAnomalyDetectionSNSPublishingPermissions")
 *                     .actions("SNS:Publish")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("costalerts.amazonaws.com")
 *                         .build())
 *                     .resources(costAnomalyUpdates.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("__default_statement_ID")
 *                     .actions(
 *                         "SNS:Subscribe",
 *                         "SNS:SetTopicAttributes",
 *                         "SNS:RemovePermission",
 *                         "SNS:Receive",
 *                         "SNS:Publish",
 *                         "SNS:ListSubscriptionsByTopic",
 *                         "SNS:GetTopicAttributes",
 *                         "SNS:DeleteTopic",
 *                         "SNS:AddPermission")
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("AWS:SourceOwner")
 *                         .values(var_.account-id())
 *                         .build())
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("*")
 *                         .build())
 *                     .resources(costAnomalyUpdates.arn())
 *                     .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(costAnomalyUpdates.arn())
 *             .policy(snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicy -> snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var anomalyMonitor = new AnomalyMonitor("anomalyMonitor", AnomalyMonitorArgs.builder()
 *             .monitorType("DIMENSIONAL")
 *             .monitorDimension("SERVICE")
 *             .build());
 *         var realtimeSubscription = new AnomalySubscription("realtimeSubscription", AnomalySubscriptionArgs.builder()
 *             .frequency("IMMEDIATE")
 *             .monitorArnLists(anomalyMonitor.arn())
 *             .subscribers(AnomalySubscriptionSubscriberArgs.builder()
 *                 .type("SNS")
 *                 .address(costAnomalyUpdates.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(default_)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ce_anomaly_subscription` using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:costexplorer/anomalySubscription:AnomalySubscription example AnomalySubscriptionARN
 * ```
 * @property accountId The unique identifier for the AWS account in which the anomaly subscription ought to be created.
 * @property frequency The frequency that anomaly reports are sent. Valid Values: `DAILY` | `IMMEDIATE` | `WEEKLY`.
 * @property monitorArnLists A list of cost anomaly monitors.
 * @property name The name for the subscription.
 * @property subscribers A subscriber configuration. Multiple subscribers can be defined.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property thresholdExpression An Expression object used to specify the anomalies that you want to generate alerts for. See Threshold Expression.
 */
public data class AnomalySubscriptionArgs(
    public val accountId: Output<String>? = null,
    public val frequency: Output<String>? = null,
    public val monitorArnLists: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val subscribers: Output<List<AnomalySubscriptionSubscriberArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val thresholdExpression: Output<AnomalySubscriptionThresholdExpressionArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.AnomalySubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.AnomalySubscriptionArgs =
        com.pulumi.aws.costexplorer.AnomalySubscriptionArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .frequency(frequency?.applyValue({ args0 -> args0 }))
            .monitorArnLists(monitorArnLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subscribers(
                subscribers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .thresholdExpression(
                thresholdExpression?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AnomalySubscriptionArgs].
 */
@PulumiTagMarker
public class AnomalySubscriptionArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var frequency: Output<String>? = null

    private var monitorArnLists: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var subscribers: Output<List<AnomalySubscriptionSubscriberArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var thresholdExpression: Output<AnomalySubscriptionThresholdExpressionArgs>? = null

    /**
     * @param value The unique identifier for the AWS account in which the anomaly subscription ought to be created.
     */
    @JvmName("rvtfehhfxkwbfmbc")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The frequency that anomaly reports are sent. Valid Values: `DAILY` | `IMMEDIATE` | `WEEKLY`.
     */
    @JvmName("xwxhyphcumnhmfod")
    public suspend fun frequency(`value`: Output<String>) {
        this.frequency = value
    }

    /**
     * @param value A list of cost anomaly monitors.
     */
    @JvmName("vepjfdxowmjnatbq")
    public suspend fun monitorArnLists(`value`: Output<List<String>>) {
        this.monitorArnLists = value
    }

    @JvmName("vkcfiyigsnelktad")
    public suspend fun monitorArnLists(vararg values: Output<String>) {
        this.monitorArnLists = Output.all(values.asList())
    }

    /**
     * @param values A list of cost anomaly monitors.
     */
    @JvmName("viceuyovhqxuybpp")
    public suspend fun monitorArnLists(values: List<Output<String>>) {
        this.monitorArnLists = Output.all(values)
    }

    /**
     * @param value The name for the subscription.
     */
    @JvmName("fcwurjelrutpbfad")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A subscriber configuration. Multiple subscribers can be defined.
     */
    @JvmName("qkxskqmtlirpaelw")
    public suspend fun subscribers(`value`: Output<List<AnomalySubscriptionSubscriberArgs>>) {
        this.subscribers = value
    }

    @JvmName("mqmsnxtvjxjjcmht")
    public suspend fun subscribers(vararg values: Output<AnomalySubscriptionSubscriberArgs>) {
        this.subscribers = Output.all(values.asList())
    }

    /**
     * @param values A subscriber configuration. Multiple subscribers can be defined.
     */
    @JvmName("cadqgqvngcjofosv")
    public suspend fun subscribers(values: List<Output<AnomalySubscriptionSubscriberArgs>>) {
        this.subscribers = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yaqtsfbqsyhnvyml")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An Expression object used to specify the anomalies that you want to generate alerts for. See Threshold Expression.
     */
    @JvmName("jitqlxcasublnxnn")
    public suspend
    fun thresholdExpression(`value`: Output<AnomalySubscriptionThresholdExpressionArgs>) {
        this.thresholdExpression = value
    }

    /**
     * @param value The unique identifier for the AWS account in which the anomaly subscription ought to be created.
     */
    @JvmName("jmsvbgqbswhrqtjj")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The frequency that anomaly reports are sent. Valid Values: `DAILY` | `IMMEDIATE` | `WEEKLY`.
     */
    @JvmName("ofgghefcwgessbes")
    public suspend fun frequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value A list of cost anomaly monitors.
     */
    @JvmName("ttlepyhnvrubttpn")
    public suspend fun monitorArnLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorArnLists = mapped
    }

    /**
     * @param values A list of cost anomaly monitors.
     */
    @JvmName("qmpoonxffaiyidxf")
    public suspend fun monitorArnLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitorArnLists = mapped
    }

    /**
     * @param value The name for the subscription.
     */
    @JvmName("nipvwouhqoladqoa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A subscriber configuration. Multiple subscribers can be defined.
     */
    @JvmName("qgcymlhcwqtqsesm")
    public suspend fun subscribers(`value`: List<AnomalySubscriptionSubscriberArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscribers = mapped
    }

    /**
     * @param argument A subscriber configuration. Multiple subscribers can be defined.
     */
    @JvmName("dbjengywhbqldmys")
    public suspend
    fun subscribers(argument: List<suspend AnomalySubscriptionSubscriberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnomalySubscriptionSubscriberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param argument A subscriber configuration. Multiple subscribers can be defined.
     */
    @JvmName("pxllgfwdrwyuggey")
    public suspend fun subscribers(
        vararg
        argument: suspend AnomalySubscriptionSubscriberArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AnomalySubscriptionSubscriberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param argument A subscriber configuration. Multiple subscribers can be defined.
     */
    @JvmName("njopmcmkjrogaapj")
    public suspend
    fun subscribers(argument: suspend AnomalySubscriptionSubscriberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnomalySubscriptionSubscriberArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param values A subscriber configuration. Multiple subscribers can be defined.
     */
    @JvmName("xujeuosibwulpkha")
    public suspend fun subscribers(vararg values: AnomalySubscriptionSubscriberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscribers = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fibiiymkufdnakgs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dvvmvuagawsxwybs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value An Expression object used to specify the anomalies that you want to generate alerts for. See Threshold Expression.
     */
    @JvmName("udqgnngsyeimdvaa")
    public suspend fun thresholdExpression(`value`: AnomalySubscriptionThresholdExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdExpression = mapped
    }

    /**
     * @param argument An Expression object used to specify the anomalies that you want to generate alerts for. See Threshold Expression.
     */
    @JvmName("atjvooypqbomsdlt")
    public suspend
    fun thresholdExpression(argument: suspend AnomalySubscriptionThresholdExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.thresholdExpression = mapped
    }

    internal fun build(): AnomalySubscriptionArgs = AnomalySubscriptionArgs(
        accountId = accountId,
        frequency = frequency,
        monitorArnLists = monitorArnLists,
        name = name,
        subscribers = subscribers,
        tags = tags,
        thresholdExpression = thresholdExpression,
    )
}
