@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CostAllocationTag].
 */
@PulumiTagMarker
public class CostAllocationTagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CostAllocationTagArgs = CostAllocationTagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CostAllocationTagArgsBuilder.() -> Unit) {
        val builder = CostAllocationTagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CostAllocationTag {
        val builtJavaResource = com.pulumi.aws.costexplorer.CostAllocationTag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CostAllocationTag(builtJavaResource)
    }
}

/**
 * Provides a CE Cost Allocation Tag.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.CostAllocationTag;
 * import com.pulumi.aws.costexplorer.CostAllocationTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CostAllocationTag("example", CostAllocationTagArgs.builder()
 *             .status("Active")
 *             .tagKey("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ce_cost_allocation_tag` using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:costexplorer/costAllocationTag:CostAllocationTag example key
 * ```
 *
 */
public class CostAllocationTag internal constructor(
    override val javaResource: com.pulumi.aws.costexplorer.CostAllocationTag,
) : KotlinCustomResource(javaResource, CostAllocationTagMapper) {
    /**
     * The status of a cost allocation tag. Valid values are `Active` and `Inactive`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The key for the cost allocation tag.
     */
    public val tagKey: Output<String>
        get() = javaResource.tagKey().applyValue({ args0 -> args0 })

    /**
     * The type of cost allocation tag.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CostAllocationTagMapper : ResourceMapper<CostAllocationTag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.costexplorer.CostAllocationTag::class == javaResource::class

    override fun map(javaResource: Resource): CostAllocationTag = CostAllocationTag(
        javaResource as
            com.pulumi.aws.costexplorer.CostAllocationTag,
    )
}

/**
 * @see [CostAllocationTag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CostAllocationTag].
 */
public suspend fun costAllocationTag(
    name: String,
    block: suspend CostAllocationTagResourceBuilder.() -> Unit,
): CostAllocationTag {
    val builder = CostAllocationTagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CostAllocationTag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun costAllocationTag(name: String): CostAllocationTag {
    val builder = CostAllocationTagResourceBuilder()
    builder.name(name)
    return builder.build()
}
