@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.aws.costexplorer.CostAllocationTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CE Cost Allocation Tag.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.CostAllocationTag;
 * import com.pulumi.aws.costexplorer.CostAllocationTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CostAllocationTag("example", CostAllocationTagArgs.builder()
 *             .status("Active")
 *             .tagKey("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ce_cost_allocation_tag` using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:costexplorer/costAllocationTag:CostAllocationTag example key
 * ```
 * @property status The status of a cost allocation tag. Valid values are `Active` and `Inactive`.
 * @property tagKey The key for the cost allocation tag.
 */
public data class CostAllocationTagArgs(
    public val status: Output<String>? = null,
    public val tagKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.CostAllocationTagArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.CostAllocationTagArgs =
        com.pulumi.aws.costexplorer.CostAllocationTagArgs.builder()
            .status(status?.applyValue({ args0 -> args0 }))
            .tagKey(tagKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CostAllocationTagArgs].
 */
@PulumiTagMarker
public class CostAllocationTagArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    private var tagKey: Output<String>? = null

    /**
     * @param value The status of a cost allocation tag. Valid values are `Active` and `Inactive`.
     */
    @JvmName("bmpxxnexjpdcofyx")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The key for the cost allocation tag.
     */
    @JvmName("bnjckixfkcaoriso")
    public suspend fun tagKey(`value`: Output<String>) {
        this.tagKey = value
    }

    /**
     * @param value The status of a cost allocation tag. Valid values are `Active` and `Inactive`.
     */
    @JvmName("ldsdgsvnlaxexeey")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The key for the cost allocation tag.
     */
    @JvmName("iehqcodduvnpswgv")
    public suspend fun tagKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKey = mapped
    }

    internal fun build(): CostAllocationTagArgs = CostAllocationTagArgs(
        status = status,
        tagKey = tagKey,
    )
}
