@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.aws.costexplorer.CostCategoryArgs.builder
import com.pulumi.aws.costexplorer.kotlin.inputs.CostCategoryRuleArgs
import com.pulumi.aws.costexplorer.kotlin.inputs.CostCategoryRuleArgsBuilder
import com.pulumi.aws.costexplorer.kotlin.inputs.CostCategorySplitChargeRuleArgs
import com.pulumi.aws.costexplorer.kotlin.inputs.CostCategorySplitChargeRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CE Cost Category.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.CostCategory;
 * import com.pulumi.aws.costexplorer.CostCategoryArgs;
 * import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleArgs;
 * import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleArgs;
 * import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleDimensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new CostCategory("test", CostCategoryArgs.builder()
 *             .rules(
 *                 CostCategoryRuleArgs.builder()
 *                     .rule(CostCategoryRuleRuleArgs.builder()
 *                         .dimension(CostCategoryRuleRuleDimensionArgs.builder()
 *                             .key("LINKED_ACCOUNT_NAME")
 *                             .matchOptions("ENDS_WITH")
 *                             .values("-prod")
 *                             .build())
 *                         .build())
 *                     .value("production")
 *                     .build(),
 *                 CostCategoryRuleArgs.builder()
 *                     .rule(CostCategoryRuleRuleArgs.builder()
 *                         .dimension(CostCategoryRuleRuleDimensionArgs.builder()
 *                             .key("LINKED_ACCOUNT_NAME")
 *                             .matchOptions("ENDS_WITH")
 *                             .values("-stg")
 *                             .build())
 *                         .build())
 *                     .value("staging")
 *                     .build(),
 *                 CostCategoryRuleArgs.builder()
 *                     .rule(CostCategoryRuleRuleArgs.builder()
 *                         .dimension(CostCategoryRuleRuleDimensionArgs.builder()
 *                             .key("LINKED_ACCOUNT_NAME")
 *                             .matchOptions("ENDS_WITH")
 *                             .values("-dev")
 *                             .build())
 *                         .build())
 *                     .value("testing")
 *                     .build())
 *             .ruleVersion("CostCategoryExpression.v1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ce_cost_category` using the id. For example:
 * ```sh
 *  $ pulumi import aws:costexplorer/costCategory:CostCategory example costCategoryARN
 * ```
 * @property defaultValue Default value for the cost category.
 * @property effectiveStart The Cost Category's effective start date. It can only be a billing start date (first day of the month). If the date isn't provided, it's the first day of the current month. Dates can't be before the previous twelve months, or in the future. For example `2022-11-01T00:00:00Z`.
 * The following arguments are optional:
 * @property name Unique name for the Cost Category.
 * @property ruleVersion Rule schema version in this particular Cost Category.
 * @property rules Configuration block for the Cost Category rules used to categorize costs. See below.
 * @property splitChargeRules Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryArgs(
    public val defaultValue: Output<String>? = null,
    public val effectiveStart: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ruleVersion: Output<String>? = null,
    public val rules: Output<List<CostCategoryRuleArgs>>? = null,
    public val splitChargeRules: Output<List<CostCategorySplitChargeRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.CostCategoryArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.CostCategoryArgs =
        com.pulumi.aws.costexplorer.CostCategoryArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .effectiveStart(effectiveStart?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleVersion(ruleVersion?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .splitChargeRules(
                splitChargeRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CostCategoryArgs].
 */
@PulumiTagMarker
public class CostCategoryArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var effectiveStart: Output<String>? = null

    private var name: Output<String>? = null

    private var ruleVersion: Output<String>? = null

    private var rules: Output<List<CostCategoryRuleArgs>>? = null

    private var splitChargeRules: Output<List<CostCategorySplitChargeRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Default value for the cost category.
     */
    @JvmName("jonjugobktcagmhf")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value The Cost Category's effective start date. It can only be a billing start date (first day of the month). If the date isn't provided, it's the first day of the current month. Dates can't be before the previous twelve months, or in the future. For example `2022-11-01T00:00:00Z`.
     * The following arguments are optional:
     */
    @JvmName("luubviudmffdrlqn")
    public suspend fun effectiveStart(`value`: Output<String>) {
        this.effectiveStart = value
    }

    /**
     * @param value Unique name for the Cost Category.
     */
    @JvmName("csjbxpdsxesltqjl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rule schema version in this particular Cost Category.
     */
    @JvmName("rlovbkpxixopsyeq")
    public suspend fun ruleVersion(`value`: Output<String>) {
        this.ruleVersion = value
    }

    /**
     * @param value Configuration block for the Cost Category rules used to categorize costs. See below.
     */
    @JvmName("iycdyhnfdvhhchcw")
    public suspend fun rules(`value`: Output<List<CostCategoryRuleArgs>>) {
        this.rules = value
    }

    @JvmName("dekyusxtmjwvrtku")
    public suspend fun rules(vararg values: Output<CostCategoryRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the Cost Category rules used to categorize costs. See below.
     */
    @JvmName("kjgrxsjjardsgcwe")
    public suspend fun rules(values: List<Output<CostCategoryRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
     */
    @JvmName("rvsfusoudpujeqka")
    public suspend fun splitChargeRules(`value`: Output<List<CostCategorySplitChargeRuleArgs>>) {
        this.splitChargeRules = value
    }

    @JvmName("moiurpajboueeunw")
    public suspend fun splitChargeRules(vararg values: Output<CostCategorySplitChargeRuleArgs>) {
        this.splitChargeRules = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
     */
    @JvmName("dbvwbiwgqmmecfhn")
    public suspend fun splitChargeRules(values: List<Output<CostCategorySplitChargeRuleArgs>>) {
        this.splitChargeRules = Output.all(values)
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tbycbybhtgmfjuhv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Default value for the cost category.
     */
    @JvmName("fgnqgsueyovohaal")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value The Cost Category's effective start date. It can only be a billing start date (first day of the month). If the date isn't provided, it's the first day of the current month. Dates can't be before the previous twelve months, or in the future. For example `2022-11-01T00:00:00Z`.
     * The following arguments are optional:
     */
    @JvmName("tjqpqpjqmnckmqvn")
    public suspend fun effectiveStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveStart = mapped
    }

    /**
     * @param value Unique name for the Cost Category.
     */
    @JvmName("iymoslpdgqirfrlv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rule schema version in this particular Cost Category.
     */
    @JvmName("kovjmdpolxuskmfr")
    public suspend fun ruleVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleVersion = mapped
    }

    /**
     * @param value Configuration block for the Cost Category rules used to categorize costs. See below.
     */
    @JvmName("wcpcdiwuliwiqofv")
    public suspend fun rules(`value`: List<CostCategoryRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Configuration block for the Cost Category rules used to categorize costs. See below.
     */
    @JvmName("hvlicjyawvxmwccn")
    public suspend fun rules(argument: List<suspend CostCategoryRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Configuration block for the Cost Category rules used to categorize costs. See below.
     */
    @JvmName("cmerhfdrdghpetsb")
    public suspend fun rules(vararg argument: suspend CostCategoryRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Configuration block for the Cost Category rules used to categorize costs. See below.
     */
    @JvmName("cdphfeoxnuagnvpy")
    public suspend fun rules(argument: suspend CostCategoryRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CostCategoryRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Configuration block for the Cost Category rules used to categorize costs. See below.
     */
    @JvmName("hedtewhbjkcwuydt")
    public suspend fun rules(vararg values: CostCategoryRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
     */
    @JvmName("hvtumpnbyxnuosvp")
    public suspend fun splitChargeRules(`value`: List<CostCategorySplitChargeRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.splitChargeRules = mapped
    }

    /**
     * @param argument Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
     */
    @JvmName("iejbqhkqhurlcrjy")
    public suspend
    fun splitChargeRules(argument: List<suspend CostCategorySplitChargeRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategorySplitChargeRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.splitChargeRules = mapped
    }

    /**
     * @param argument Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
     */
    @JvmName("jtmcnebtycutwflp")
    public suspend fun splitChargeRules(
        vararg
        argument: suspend CostCategorySplitChargeRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CostCategorySplitChargeRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.splitChargeRules = mapped
    }

    /**
     * @param argument Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
     */
    @JvmName("cndhnwnigsfuinfs")
    public suspend
    fun splitChargeRules(argument: suspend CostCategorySplitChargeRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategorySplitChargeRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.splitChargeRules = mapped
    }

    /**
     * @param values Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
     */
    @JvmName("yjnhxmaaxkdkliyg")
    public suspend fun splitChargeRules(vararg values: CostCategorySplitChargeRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.splitChargeRules = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wqlgexomchwkcecn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hdrmkuerxlncxskg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CostCategoryArgs = CostCategoryArgs(
        defaultValue = defaultValue,
        effectiveStart = effectiveStart,
        name = name,
        ruleVersion = ruleVersion,
        rules = rules,
        splitChargeRules = splitChargeRules,
        tags = tags,
    )
}
