@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionNotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on  values. See Cost Category below.
 * @property dimension Configuration block for the specific Dimension to use for.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AnomalySubscriptionThresholdExpressionNotArgs(
    public val costCategory: Output<AnomalySubscriptionThresholdExpressionNotCostCategoryArgs>? =
        null,
    public val dimension: Output<AnomalySubscriptionThresholdExpressionNotDimensionArgs>? = null,
    public val tags: Output<AnomalySubscriptionThresholdExpressionNotTagsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionNotArgs> {
    override fun toJava():
        com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionNotArgs =
        com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionNotArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnomalySubscriptionThresholdExpressionNotArgs].
 */
@PulumiTagMarker
public class AnomalySubscriptionThresholdExpressionNotArgsBuilder internal constructor() {
    private var costCategory: Output<AnomalySubscriptionThresholdExpressionNotCostCategoryArgs>? =
        null

    private var dimension: Output<AnomalySubscriptionThresholdExpressionNotDimensionArgs>? = null

    private var tags: Output<AnomalySubscriptionThresholdExpressionNotTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("vbnqnlnpqttfdxyc")
    public suspend
    fun costCategory(`value`: Output<AnomalySubscriptionThresholdExpressionNotCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific Dimension to use for.
     */
    @JvmName("unelfkqpsdbiivnt")
    public suspend
    fun dimension(`value`: Output<AnomalySubscriptionThresholdExpressionNotDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mflurjcsjcpbwutg")
    public suspend fun tags(`value`: Output<AnomalySubscriptionThresholdExpressionNotTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("ipwjwvufcnqptjxk")
    public suspend
    fun costCategory(`value`: AnomalySubscriptionThresholdExpressionNotCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("fappvmrwghbhmktg")
    public suspend
    fun costCategory(argument: suspend AnomalySubscriptionThresholdExpressionNotCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnomalySubscriptionThresholdExpressionNotCostCategoryArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific Dimension to use for.
     */
    @JvmName("xnmdfqxptoijdwep")
    public suspend fun dimension(`value`: AnomalySubscriptionThresholdExpressionNotDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific Dimension to use for.
     */
    @JvmName("pbddnhhlnvydvlfc")
    public suspend
    fun dimension(argument: suspend AnomalySubscriptionThresholdExpressionNotDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionNotDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("phjfowfwhueakgrk")
    public suspend fun tags(`value`: AnomalySubscriptionThresholdExpressionNotTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("styrvxbpfolvjsbk")
    public suspend
    fun tags(argument: suspend AnomalySubscriptionThresholdExpressionNotTagsArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionNotTagsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): AnomalySubscriptionThresholdExpressionNotArgs =
        AnomalySubscriptionThresholdExpressionNotArgs(
            costCategory = costCategory,
            dimension = dimension,
            tags = tags,
        )
}
