@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionOrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on  values. See Cost Category below.
 * @property dimension Configuration block for the specific Dimension to use for.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AnomalySubscriptionThresholdExpressionOrArgs(
    public val costCategory: Output<AnomalySubscriptionThresholdExpressionOrCostCategoryArgs>? = null,
    public val dimension: Output<AnomalySubscriptionThresholdExpressionOrDimensionArgs>? = null,
    public val tags: Output<AnomalySubscriptionThresholdExpressionOrTagsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionOrArgs> {
    override fun toJava():
        com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionOrArgs =
        com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionOrArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnomalySubscriptionThresholdExpressionOrArgs].
 */
@PulumiTagMarker
public class AnomalySubscriptionThresholdExpressionOrArgsBuilder internal constructor() {
    private var costCategory: Output<AnomalySubscriptionThresholdExpressionOrCostCategoryArgs>? = null

    private var dimension: Output<AnomalySubscriptionThresholdExpressionOrDimensionArgs>? = null

    private var tags: Output<AnomalySubscriptionThresholdExpressionOrTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("pesjsoxyhlmumplw")
    public suspend
    fun costCategory(`value`: Output<AnomalySubscriptionThresholdExpressionOrCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific Dimension to use for.
     */
    @JvmName("paxvjmvnotspxhkr")
    public suspend
    fun dimension(`value`: Output<AnomalySubscriptionThresholdExpressionOrDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nokshancwslcpngi")
    public suspend fun tags(`value`: Output<AnomalySubscriptionThresholdExpressionOrTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("nvbnioyycnenqnyi")
    public suspend
    fun costCategory(`value`: AnomalySubscriptionThresholdExpressionOrCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("jlsulftviebbnrpa")
    public suspend
    fun costCategory(argument: suspend AnomalySubscriptionThresholdExpressionOrCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionOrCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific Dimension to use for.
     */
    @JvmName("vatmjdcmijrostge")
    public suspend fun dimension(`value`: AnomalySubscriptionThresholdExpressionOrDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific Dimension to use for.
     */
    @JvmName("abonctbwuxpowyyl")
    public suspend
    fun dimension(argument: suspend AnomalySubscriptionThresholdExpressionOrDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionOrDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iuyyccyqqmbatdkv")
    public suspend fun tags(`value`: AnomalySubscriptionThresholdExpressionOrTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xksalqokkypmjhhe")
    public suspend
    fun tags(argument: suspend AnomalySubscriptionThresholdExpressionOrTagsArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionOrTagsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): AnomalySubscriptionThresholdExpressionOrArgs =
        AnomalySubscriptionThresholdExpressionOrArgs(
            costCategory = costCategory,
            dimension = dimension,
            tags = tags,
        )
}
