@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property inheritedValue Configuration block for the value the line item is categorized as if the line item contains the matched dimension. See below.
 * @property rule Configuration block for the `Expression` object used to categorize costs. See below.
 * @property type You can define the CostCategoryRule rule type as either `REGULAR` or `INHERITED_VALUE`.
 * @property value Default value for the cost category.
 */
public data class CostCategoryRuleArgs(
    public val inheritedValue: Output<CostCategoryRuleInheritedValueArgs>? = null,
    public val rule: Output<CostCategoryRuleRuleArgs>? = null,
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleArgs.builder()
            .inheritedValue(inheritedValue?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rule(rule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CostCategoryRuleArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleArgsBuilder internal constructor() {
    private var inheritedValue: Output<CostCategoryRuleInheritedValueArgs>? = null

    private var rule: Output<CostCategoryRuleRuleArgs>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Configuration block for the value the line item is categorized as if the line item contains the matched dimension. See below.
     */
    @JvmName("ppgmtpvjhtbjwgkt")
    public suspend fun inheritedValue(`value`: Output<CostCategoryRuleInheritedValueArgs>) {
        this.inheritedValue = value
    }

    /**
     * @param value Configuration block for the `Expression` object used to categorize costs. See below.
     */
    @JvmName("umiqwrkwemhwnriq")
    public suspend fun rule(`value`: Output<CostCategoryRuleRuleArgs>) {
        this.rule = value
    }

    /**
     * @param value You can define the CostCategoryRule rule type as either `REGULAR` or `INHERITED_VALUE`.
     */
    @JvmName("vcrhtbwfyyrxdvmo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Default value for the cost category.
     */
    @JvmName("dbjevymvohmcrqhg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Configuration block for the value the line item is categorized as if the line item contains the matched dimension. See below.
     */
    @JvmName("kgwhsahccnfjoeeq")
    public suspend fun inheritedValue(`value`: CostCategoryRuleInheritedValueArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inheritedValue = mapped
    }

    /**
     * @param argument Configuration block for the value the line item is categorized as if the line item contains the matched dimension. See below.
     */
    @JvmName("wshdirkidrdfaaak")
    public suspend
    fun inheritedValue(argument: suspend CostCategoryRuleInheritedValueArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleInheritedValueArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inheritedValue = mapped
    }

    /**
     * @param value Configuration block for the `Expression` object used to categorize costs. See below.
     */
    @JvmName("mgregghnsmegpdos")
    public suspend fun rule(`value`: CostCategoryRuleRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param argument Configuration block for the `Expression` object used to categorize costs. See below.
     */
    @JvmName("dhpvmoycfmkgyaay")
    public suspend fun rule(argument: suspend CostCategoryRuleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rule = mapped
    }

    /**
     * @param value You can define the CostCategoryRule rule type as either `REGULAR` or `INHERITED_VALUE`.
     */
    @JvmName("npseotkbjyamseat")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Default value for the cost category.
     */
    @JvmName("xcdiwodgrmthohpt")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CostCategoryRuleArgs = CostCategoryRuleArgs(
        inheritedValue = inheritedValue,
        rule = rule,
        type = type,
        `value` = `value`,
    )
}
