@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleAndArgs(
    public val costCategory: Output<CostCategoryRuleRuleAndCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleAndDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleAndTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleAndArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleAndArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleAndCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleAndDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleAndTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("fnoywyfunkcwbimq")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleAndCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("sodqbmlxepfrhful")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleAndDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bvoffjvmkorsoitm")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleAndTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("jqabhqednrbairll")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleAndCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("kwmuaoyslmjyywvh")
    public suspend
    fun costCategory(argument: suspend CostCategoryRuleRuleAndCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("ydfwgqbmgcgggsdo")
    public suspend fun dimension(`value`: CostCategoryRuleRuleAndDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("xsvbmeldqhedoqka")
    public suspend
    fun dimension(argument: suspend CostCategoryRuleRuleAndDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gdpeojgkpuaobdmt")
    public suspend fun tags(`value`: CostCategoryRuleRuleAndTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cuvpmjrbqgodnlna")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleAndTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleAndArgs = CostCategoryRuleRuleAndArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
