@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class CostCategoryRuleRuleArgs(
    public val ands: Output<List<CostCategoryRuleRuleAndArgs>>? = null,
    public val costCategory: Output<CostCategoryRuleRuleCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleDimensionArgs>? = null,
    public val not: Output<CostCategoryRuleRuleNotArgs>? = null,
    public val ors: Output<List<CostCategoryRuleRuleOrArgs>>? = null,
    public val tags: Output<CostCategoryRuleRuleTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleArgs.builder()
            .ands(ands?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .not(not?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ors(ors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleArgsBuilder internal constructor() {
    private var ands: Output<List<CostCategoryRuleRuleAndArgs>>? = null

    private var costCategory: Output<CostCategoryRuleRuleCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleDimensionArgs>? = null

    private var not: Output<CostCategoryRuleRuleNotArgs>? = null

    private var ors: Output<List<CostCategoryRuleRuleOrArgs>>? = null

    private var tags: Output<CostCategoryRuleRuleTagsArgs>? = null

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("ayehuvpdbedvroyr")
    public suspend fun ands(`value`: Output<List<CostCategoryRuleRuleAndArgs>>) {
        this.ands = value
    }

    @JvmName("liupimylcvqvnmdj")
    public suspend fun ands(vararg values: Output<CostCategoryRuleRuleAndArgs>) {
        this.ands = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("ocyuxkchwhlaochr")
    public suspend fun ands(values: List<Output<CostCategoryRuleRuleAndArgs>>) {
        this.ands = Output.all(values)
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("svsyhdcwsjglhhsk")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("jfgrjxgpudcaysxl")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("onaeftcqlkjcdmeq")
    public suspend fun not(`value`: Output<CostCategoryRuleRuleNotArgs>) {
        this.not = value
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("nuaglyiltfynjfcs")
    public suspend fun ors(`value`: Output<List<CostCategoryRuleRuleOrArgs>>) {
        this.ors = value
    }

    @JvmName("ydjkoojodldtecyv")
    public suspend fun ors(vararg values: Output<CostCategoryRuleRuleOrArgs>) {
        this.ors = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("ltvrjfilysqlkwle")
    public suspend fun ors(values: List<Output<CostCategoryRuleRuleOrArgs>>) {
        this.ors = Output.all(values)
    }

    /**
     * @param value Configuration block for the specific `Tag` to use for `Expression`. See below.
     */
    @JvmName("qoscyrbjimhefeax")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("xikjofukfdknwghk")
    public suspend fun ands(`value`: List<CostCategoryRuleRuleAndArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("cjjulyhrlhmpqyox")
    public suspend fun ands(argument: List<suspend CostCategoryRuleRuleAndArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("dymajeqjcecgiycg")
    public suspend fun ands(vararg argument: suspend CostCategoryRuleRuleAndArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("cattiirenyccbnpp")
    public suspend fun ands(argument: suspend CostCategoryRuleRuleAndArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategoryRuleRuleAndArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("cuybdumfaxsmyele")
    public suspend fun ands(vararg values: CostCategoryRuleRuleAndArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("bauhjljxhgasbqno")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("icswbwsvqochuqry")
    public suspend
    fun costCategory(argument: suspend CostCategoryRuleRuleCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("vtrykhfurborhepe")
    public suspend fun dimension(`value`: CostCategoryRuleRuleDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("htssbofeeuwnekdj")
    public suspend
    fun dimension(argument: suspend CostCategoryRuleRuleDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleDimensionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("snkqiywjnnswxxcg")
    public suspend fun not(`value`: CostCategoryRuleRuleNotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.not = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("hrbrbhclxnvpxluj")
    public suspend fun not(argument: suspend CostCategoryRuleRuleNotArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.not = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("hpgsunbhtnwnrxyx")
    public suspend fun ors(`value`: List<CostCategoryRuleRuleOrArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("qryhbhvcrwtqjkoq")
    public suspend fun ors(argument: List<suspend CostCategoryRuleRuleOrArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleOrArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("ddsbtttnbqweorki")
    public suspend fun ors(vararg argument: suspend CostCategoryRuleRuleOrArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleOrArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("wneqsprnhyvghhqf")
    public suspend fun ors(argument: suspend CostCategoryRuleRuleOrArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CostCategoryRuleRuleOrArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("bxfnmpkbxdtvuiuu")
    public suspend fun ors(vararg values: CostCategoryRuleRuleOrArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param value Configuration block for the specific `Tag` to use for `Expression`. See below.
     */
    @JvmName("lljeqwvqvkgripjs")
    public suspend fun tags(`value`: CostCategoryRuleRuleTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Configuration block for the specific `Tag` to use for `Expression`. See below.
     */
    @JvmName("mxnhyqsinucgogja")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleArgs = CostCategoryRuleRuleArgs(
        ands = ands,
        costCategory = costCategory,
        dimension = dimension,
        not = not,
        ors = ors,
        tags = tags,
    )
}
