@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleNotArgs(
    public val costCategory: Output<CostCategoryRuleRuleNotCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleNotDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleNotTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleNotArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleNotArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleNotCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleNotDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleNotTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("xkbyiokgjdqvrxxn")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleNotCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("acbyexhamamlhwxu")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleNotDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tlmcedirtuiwvrpe")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleNotTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("kkujgxikcovdnrjh")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleNotCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("ggewqakjkpghkgqx")
    public suspend
    fun costCategory(argument: suspend CostCategoryRuleRuleNotCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("ghewkfmrdnbyirix")
    public suspend fun dimension(`value`: CostCategoryRuleRuleNotDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("ljeajnpljujkgggb")
    public suspend
    fun dimension(argument: suspend CostCategoryRuleRuleNotDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uhbwphnhpjmxjlfj")
    public suspend fun tags(`value`: CostCategoryRuleRuleNotTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nvxxnknmrdhkilgj")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleNotTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleNotArgs = CostCategoryRuleRuleNotArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
