@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleOrArgs(
    public val costCategory: Output<CostCategoryRuleRuleOrCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleOrDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleOrTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleOrArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleOrArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleOrCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleOrDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleOrTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("okeuktfaqhcnuiir")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleOrCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("metneewrsmogrqne")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleOrDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mwddxfajqprawohf")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleOrTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("pytyqtxackgcmanh")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleOrCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("leetiejjarxhfpmk")
    public suspend
    fun costCategory(argument: suspend CostCategoryRuleRuleOrCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("jdbbyjwhtsiulmgh")
    public suspend fun dimension(`value`: CostCategoryRuleRuleOrDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("xpwvexciswtkfpqx")
    public suspend
    fun dimension(argument: suspend CostCategoryRuleRuleOrDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrDimensionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qwghyfxacwqxichf")
    public suspend fun tags(`value`: CostCategoryRuleRuleOrTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gjvcprdsihgofbjn")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleOrTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleOrArgs = CostCategoryRuleRuleOrArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
