@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Tags that match your request.
 */
public data class GetTagsFilter(
    public val ands: List<GetTagsFilterAnd>? = null,
    public val costCategory: GetTagsFilterCostCategory? = null,
    public val dimension: GetTagsFilterDimension? = null,
    public val not: GetTagsFilterNot? = null,
    public val ors: List<GetTagsFilterOr>? = null,
    public val tags: GetTagsFilterTags? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsFilter> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsFilter =
        com.pulumi.aws.costexplorer.inputs.GetTagsFilter.builder()
            .ands(ands?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .costCategory(costCategory?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .not(not?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ors(ors?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetTagsFilter].
 */
@PulumiTagMarker
public class GetTagsFilterBuilder internal constructor() {
    private var ands: List<GetTagsFilterAnd>? = null

    private var costCategory: GetTagsFilterCostCategory? = null

    private var dimension: GetTagsFilterDimension? = null

    private var not: GetTagsFilterNot? = null

    private var ors: List<GetTagsFilterOr>? = null

    private var tags: GetTagsFilterTags? = null

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("xkcsqngqauewonla")
    public suspend fun ands(`value`: List<GetTagsFilterAnd>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("xifdlwqnocodunsx")
    public suspend fun ands(argument: List<suspend GetTagsFilterAndBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTagsFilterAndBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("jbdrthfbvjimggcl")
    public suspend fun ands(vararg argument: suspend GetTagsFilterAndBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetTagsFilterAndBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("knuqjqmnsdyxhlyn")
    public suspend fun ands(argument: suspend GetTagsFilterAndBuilder.() -> Unit) {
        val toBeMapped = listOf(GetTagsFilterAndBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.ands = mapped
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("dyjtbmjcheshcnsv")
    public suspend fun ands(vararg values: GetTagsFilterAnd) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ands = mapped
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("axuvsgqareixaeuq")
    public suspend fun costCategory(`value`: GetTagsFilterCostCategory?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("fglefkjwqonmcvab")
    public suspend fun costCategory(argument: suspend GetTagsFilterCostCategoryBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterCostCategoryBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("jglggxwumsbfdhxe")
    public suspend fun dimension(`value`: GetTagsFilterDimension?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("dwiekroxbtdihuix")
    public suspend fun dimension(argument: suspend GetTagsFilterDimensionBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterDimensionBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.dimension = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("nxhrptplccngaoga")
    public suspend fun not(`value`: GetTagsFilterNot?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.not = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("lamxhsnfgyrlxbol")
    public suspend fun not(argument: suspend GetTagsFilterNotBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterNotBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.not = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("jhhwlbadhtamxjom")
    public suspend fun ors(`value`: List<GetTagsFilterOr>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("qvvvobfxjjvdjnnj")
    public suspend fun ors(argument: List<suspend GetTagsFilterOrBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetTagsFilterOrBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("sfnfrsneygijytck")
    public suspend fun ors(vararg argument: suspend GetTagsFilterOrBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetTagsFilterOrBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("yhvwfxaigpvarhrx")
    public suspend fun ors(argument: suspend GetTagsFilterOrBuilder.() -> Unit) {
        val toBeMapped = listOf(GetTagsFilterOrBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.ors = mapped
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("hgsoirlkyajkinif")
    public suspend fun ors(vararg values: GetTagsFilterOr) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ors = mapped
    }

    /**
     * @param value Tags that match your request.
     */
    @JvmName("buyfmynktlprrhij")
    public suspend fun tags(`value`: GetTagsFilterTags?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param argument Tags that match your request.
     */
    @JvmName("qyelvyamgphpqgia")
    public suspend fun tags(argument: suspend GetTagsFilterTagsBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterTagsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.tags = mapped
    }

    internal fun build(): GetTagsFilter = GetTagsFilter(
        ands = ands,
        costCategory = costCategory,
        dimension = dimension,
        not = not,
        ors = ors,
        tags = tags,
    )
}
