@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsFilterAnd.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Tags that match your request.
 */
public data class GetTagsFilterAnd(
    public val costCategory: GetTagsFilterAndCostCategory? = null,
    public val dimension: GetTagsFilterAndDimension? = null,
    public val tags: GetTagsFilterAndTags? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsFilterAnd> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsFilterAnd =
        com.pulumi.aws.costexplorer.inputs.GetTagsFilterAnd.builder()
            .costCategory(costCategory?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetTagsFilterAnd].
 */
@PulumiTagMarker
public class GetTagsFilterAndBuilder internal constructor() {
    private var costCategory: GetTagsFilterAndCostCategory? = null

    private var dimension: GetTagsFilterAndDimension? = null

    private var tags: GetTagsFilterAndTags? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("ulvucqmqblrmppar")
    public suspend fun costCategory(`value`: GetTagsFilterAndCostCategory?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("wiltgtancjvtybdv")
    public suspend
    fun costCategory(argument: suspend GetTagsFilterAndCostCategoryBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterAndCostCategoryBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("swtrndywpbtwalhp")
    public suspend fun dimension(`value`: GetTagsFilterAndDimension?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("neshkwhcnkljiwsi")
    public suspend fun dimension(argument: suspend GetTagsFilterAndDimensionBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterAndDimensionBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.dimension = mapped
    }

    /**
     * @param value Tags that match your request.
     */
    @JvmName("wncyebpnwgttjbhk")
    public suspend fun tags(`value`: GetTagsFilterAndTags?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param argument Tags that match your request.
     */
    @JvmName("ohghetnxufbdhrxv")
    public suspend fun tags(argument: suspend GetTagsFilterAndTagsBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterAndTagsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.tags = mapped
    }

    internal fun build(): GetTagsFilterAnd = GetTagsFilterAnd(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
