@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsFilterTags.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key Unique name of the Cost Category.
 * @property matchOptions Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
 * @property values Specific value of the Cost Category.
 */
public data class GetTagsFilterTags(
    public val key: String? = null,
    public val matchOptions: List<String>? = null,
    public val values: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsFilterTags> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsFilterTags =
        com.pulumi.aws.costexplorer.inputs.GetTagsFilterTags.builder()
            .key(key?.let({ args0 -> args0 }))
            .matchOptions(matchOptions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .values(values?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetTagsFilterTags].
 */
@PulumiTagMarker
public class GetTagsFilterTagsBuilder internal constructor() {
    private var key: String? = null

    private var matchOptions: List<String>? = null

    private var values: List<String>? = null

    /**
     * @param value Unique name of the Cost Category.
     */
    @JvmName("qvgndpstfwmjugqa")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("gijsudjxkorfgekl")
    public suspend fun matchOptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.matchOptions = mapped
    }

    /**
     * @param values Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("kxgvwradcamdriwv")
    public suspend fun matchOptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.matchOptions = mapped
    }

    /**
     * @param value Specific value of the Cost Category.
     */
    @JvmName("qwumfioosnqoadkm")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Specific value of the Cost Category.
     */
    @JvmName("xyagndeuufyadgdo")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetTagsFilterTags = GetTagsFilterTags(
        key = key,
        matchOptions = matchOptions,
        values = values,
    )
}
