@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTags.
 * @property filter Configuration block for the `Expression` object used to categorize costs. See below.
 * @property searchString Value that you want to search for.
 * @property sortBies Configuration block for the value by which you want to sort the data. See below.
 * @property tagKey Key of the tag that you want to return values for.
 * @property timePeriod Configuration block for the start and end dates for retrieving the dimension values.
 * The following arguments are optional:
 */
public data class GetTagsPlainArgs(
    public val filter: GetTagsFilter? = null,
    public val searchString: String? = null,
    public val sortBies: List<GetTagsSortBy>? = null,
    public val tagKey: String? = null,
    public val timePeriod: GetTagsTimePeriod,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsPlainArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsPlainArgs =
        com.pulumi.aws.costexplorer.inputs.GetTagsPlainArgs.builder()
            .filter(filter?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .searchString(searchString?.let({ args0 -> args0 }))
            .sortBies(sortBies?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tagKey(tagKey?.let({ args0 -> args0 }))
            .timePeriod(timePeriod.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetTagsPlainArgs].
 */
@PulumiTagMarker
public class GetTagsPlainArgsBuilder internal constructor() {
    private var filter: GetTagsFilter? = null

    private var searchString: String? = null

    private var sortBies: List<GetTagsSortBy>? = null

    private var tagKey: String? = null

    private var timePeriod: GetTagsTimePeriod? = null

    /**
     * @param value Configuration block for the `Expression` object used to categorize costs. See below.
     */
    @JvmName("qbsscnuauymfftbw")
    public suspend fun filter(`value`: GetTagsFilter?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param argument Configuration block for the `Expression` object used to categorize costs. See below.
     */
    @JvmName("ijqwwlgruurogtbr")
    public suspend fun filter(argument: suspend GetTagsFilterBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.filter = mapped
    }

    /**
     * @param value Value that you want to search for.
     */
    @JvmName("jjllgpguanbcpyfa")
    public suspend fun searchString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchString = mapped
    }

    /**
     * @param value Configuration block for the value by which you want to sort the data. See below.
     */
    @JvmName("webnamkmpmhpqjkj")
    public suspend fun sortBies(`value`: List<GetTagsSortBy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortBies = mapped
    }

    /**
     * @param argument Configuration block for the value by which you want to sort the data. See below.
     */
    @JvmName("waxlcdalygvytyem")
    public suspend fun sortBies(argument: List<suspend GetTagsSortByBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetTagsSortByBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.sortBies = mapped
    }

    /**
     * @param argument Configuration block for the value by which you want to sort the data. See below.
     */
    @JvmName("npvdaugpsvpmbwjl")
    public suspend fun sortBies(vararg argument: suspend GetTagsSortByBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetTagsSortByBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.sortBies = mapped
    }

    /**
     * @param argument Configuration block for the value by which you want to sort the data. See below.
     */
    @JvmName("qiupibqugysbjnwl")
    public suspend fun sortBies(argument: suspend GetTagsSortByBuilder.() -> Unit) {
        val toBeMapped = listOf(GetTagsSortByBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.sortBies = mapped
    }

    /**
     * @param values Configuration block for the value by which you want to sort the data. See below.
     */
    @JvmName("nbhycukdgguhvaqw")
    public suspend fun sortBies(vararg values: GetTagsSortBy) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sortBies = mapped
    }

    /**
     * @param value Key of the tag that you want to return values for.
     */
    @JvmName("kdvmcnawmitoljdd")
    public suspend fun tagKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tagKey = mapped
    }

    /**
     * @param value Configuration block for the start and end dates for retrieving the dimension values.
     * The following arguments are optional:
     */
    @JvmName("vbokfachpmtiyjtu")
    public suspend fun timePeriod(`value`: GetTagsTimePeriod) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.timePeriod = mapped
    }

    /**
     * @param argument Configuration block for the start and end dates for retrieving the dimension values.
     * The following arguments are optional:
     */
    @JvmName("ayunxdudedxwguwt")
    public suspend fun timePeriod(argument: suspend GetTagsTimePeriodBuilder.() -> Unit) {
        val toBeMapped = GetTagsTimePeriodBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.timePeriod = mapped
    }

    internal fun build(): GetTagsPlainArgs = GetTagsPlainArgs(
        filter = filter,
        searchString = searchString,
        sortBies = sortBies,
        tagKey = tagKey,
        timePeriod = timePeriod ?: throw PulumiNullFieldException("timePeriod"),
    )
}
