@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsSortBy.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key key that's used to sort the data. Valid values are: `BlendedCost`,  `UnblendedCost`, `AmortizedCost`, `NetAmortizedCost`, `NetUnblendedCost`, `UsageQuantity`, `NormalizedUsageAmount`.
 * @property sortOrder order that's used to sort the data. Valid values are: `ASCENDING`,  `DESCENDING`.
 */
public data class GetTagsSortBy(
    public val key: String? = null,
    public val sortOrder: String? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsSortBy> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsSortBy =
        com.pulumi.aws.costexplorer.inputs.GetTagsSortBy.builder()
            .key(key?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagsSortBy].
 */
@PulumiTagMarker
public class GetTagsSortByBuilder internal constructor() {
    private var key: String? = null

    private var sortOrder: String? = null

    /**
     * @param value key that's used to sort the data. Valid values are: `BlendedCost`,  `UnblendedCost`, `AmortizedCost`, `NetAmortizedCost`, `NetUnblendedCost`, `UsageQuantity`, `NormalizedUsageAmount`.
     */
    @JvmName("xsfecjqcmiynuysp")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value order that's used to sort the data. Valid values are: `ASCENDING`,  `DESCENDING`.
     */
    @JvmName("addgppowvprvojiv")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    internal fun build(): GetTagsSortBy = GetTagsSortBy(
        key = key,
        sortOrder = sortOrder,
    )
}
