@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property costCategory Configuration block for the filter that's based on  values. See Cost Category below.
 * @property dimension Configuration block for the specific Dimension to use for.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AnomalySubscriptionThresholdExpressionNot(
    public val costCategory: AnomalySubscriptionThresholdExpressionNotCostCategory? = null,
    public val dimension: AnomalySubscriptionThresholdExpressionNotDimension? = null,
    public val tags: AnomalySubscriptionThresholdExpressionNotTags? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.AnomalySubscriptionThresholdExpressionNot):
            AnomalySubscriptionThresholdExpressionNot = AnomalySubscriptionThresholdExpressionNot(
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionNotCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionNotDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionNotTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
