@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property inheritedValues Configuration block for the value the line item is categorized as if the line item contains the matched dimension. See below.
 * @property rules Configuration block for the `Expression` object used to categorize costs. See below.
 * @property type Parameter type.
 * @property value Default value for the cost category.
 */
public data class GetCostCategoryRule(
    public val inheritedValues: List<GetCostCategoryRuleInheritedValue>,
    public val rules: List<GetCostCategoryRuleRule>,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRule):
            GetCostCategoryRule = GetCostCategoryRule(
            inheritedValues = javaType.inheritedValues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleInheritedValue.Companion.toKotlin(args0)
                })
            }),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRule.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
