@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategories Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimensions Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property nots Return results that do not match the `Dimension` object.
 * @property ors Return results that match either `Dimension` object.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryRuleRule(
    public val ands: List<GetCostCategoryRuleRuleAnd>,
    public val costCategories: List<GetCostCategoryRuleRuleCostCategory>,
    public val dimensions: List<GetCostCategoryRuleRuleDimension>,
    public val nots: List<GetCostCategoryRuleRuleNot>,
    public val ors: List<GetCostCategoryRuleRuleOr>,
    public val tags: List<GetCostCategoryRuleRuleTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleRule):
            GetCostCategoryRuleRule = GetCostCategoryRuleRule(
            ands = javaType.ands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleAnd.Companion.toKotlin(args0)
                })
            }),
            costCategories = javaType.costCategories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleCostCategory.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleDimension.Companion.toKotlin(args0)
                })
            }),
            nots = javaType.nots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNot.Companion.toKotlin(args0)
                })
            }),
            ors = javaType.ors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOr.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
