@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property costCategories Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimensions Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryRuleRuleOr(
    public val costCategories: List<GetCostCategoryRuleRuleOrCostCategory>,
    public val dimensions: List<GetCostCategoryRuleRuleOrDimension>,
    public val tags: List<GetCostCategoryRuleRuleOrTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleRuleOr):
            GetCostCategoryRuleRuleOr = GetCostCategoryRuleRuleOr(
            costCategories = javaType.costCategories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrCostCategory.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrDimension.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
