@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property method Method that's used to define how to split your source costs across your targets. Valid values are `FIXED`, `PROPORTIONAL`, `EVEN`
 * @property parameters Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
 * @property source Cost Category value that you want to split.
 * @property targets Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules.
 */
public data class GetCostCategorySplitChargeRule(
    public val method: String,
    public val parameters: List<GetCostCategorySplitChargeRuleParameter>,
    public val source: String,
    public val targets: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategorySplitChargeRule):
            GetCostCategorySplitChargeRule = GetCostCategorySplitChargeRule(
            method = javaType.method(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategorySplitChargeRuleParameter.Companion.toKotlin(args0)
                })
            }),
            source = javaType.source(),
            targets = javaType.targets().map({ args0 -> args0 }),
        )
    }
}
