@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Tags that match your request.
 */
public data class GetTagsFilterAnd(
    public val costCategory: GetTagsFilterAndCostCategory? = null,
    public val dimension: GetTagsFilterAndDimension? = null,
    public val tags: GetTagsFilterAndTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetTagsFilterAnd):
            GetTagsFilterAnd = GetTagsFilterAnd(
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsFilterAndCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsFilterAndDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsFilterAndTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
