@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTags.
 * @property filter
 * @property id The provider-assigned unique ID for this managed resource.
 * @property searchString
 * @property sortBies
 * @property tagKey
 * @property tags Tags that match your request.
 * @property timePeriod
 */
public data class GetTagsResult(
    public val filter: GetTagsFilter? = null,
    public val id: String,
    public val searchString: String? = null,
    public val sortBies: List<GetTagsSortBy>? = null,
    public val tagKey: String? = null,
    public val tags: List<String>,
    public val timePeriod: GetTagsTimePeriod,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetTagsResult): GetTagsResult =
            GetTagsResult(
                filter = javaType.filter().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsFilter.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                id = javaType.id(),
                searchString = javaType.searchString().map({ args0 -> args0 }).orElse(null),
                sortBies = javaType.sortBies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsSortBy.Companion.toKotlin(args0)
                    })
                }),
                tagKey = javaType.tagKey().map({ args0 -> args0 }).orElse(null),
                tags = javaType.tags().map({ args0 -> args0 }),
                timePeriod = javaType.timePeriod().let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsTimePeriod.Companion.toKotlin(args0)
                }),
            )
    }
}
