@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key key that's used to sort the data. Valid values are: `BlendedCost`,  `UnblendedCost`, `AmortizedCost`, `NetAmortizedCost`, `NetUnblendedCost`, `UsageQuantity`, `NormalizedUsageAmount`.
 * @property sortOrder order that's used to sort the data. Valid values are: `ASCENDING`,  `DESCENDING`.
 */
public data class GetTagsSortBy(
    public val key: String? = null,
    public val sortOrder: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetTagsSortBy): GetTagsSortBy =
            GetTagsSortBy(
                key = javaType.key().map({ args0 -> args0 }).orElse(null),
                sortOrder = javaType.sortOrder().map({ args0 -> args0 }).orElse(null),
            )
    }
}
