@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cur.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ReportDefinition].
 */
@PulumiTagMarker
public class ReportDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReportDefinitionArgs = ReportDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReportDefinitionArgsBuilder.() -> Unit) {
        val builder = ReportDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReportDefinition {
        val builtJavaResource = com.pulumi.aws.cur.ReportDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReportDefinition(builtJavaResource)
    }
}

/**
 * Manages Cost and Usage Report Definitions.
 * > *NOTE:* The AWS Cost and Usage Report service is only available in `us-east-1` currently.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cur.ReportDefinition;
 * import com.pulumi.aws.cur.ReportDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCurReportDefinition = new ReportDefinition("exampleCurReportDefinition", ReportDefinitionArgs.builder()
 *             .additionalArtifacts(
 *                 "REDSHIFT",
 *                 "QUICKSIGHT")
 *             .additionalSchemaElements(
 *                 "RESOURCES",
 *                 "SPLIT_COST_ALLOCATION_DATA")
 *             .compression("GZIP")
 *             .format("textORcsv")
 *             .reportName("example-cur-report-definition")
 *             .s3Bucket("example-bucket-name")
 *             .s3Region("us-east-1")
 *             .timeUnit("HOURLY")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Report Definitions using the `report_name`. For example:
 * ```sh
 *  $ pulumi import aws:cur/reportDefinition:ReportDefinition example_cur_report_definition example-cur-report-definition
 * ```
 *
 */
public class ReportDefinition internal constructor(
    override val javaResource: com.pulumi.aws.cur.ReportDefinition,
) : KotlinCustomResource(javaResource, ReportDefinitionMapper) {
    /**
     * A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    public val additionalArtifacts: Output<List<String>>?
        get() = javaResource.additionalArtifacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    public val additionalSchemaElements: Output<List<String>>
        get() = javaResource.additionalSchemaElements().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The Amazon Resource Name (ARN) specifying the cur report.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
     */
    public val compression: Output<String>
        get() = javaResource.compression().applyValue({ args0 -> args0 })

    /**
     * Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
     */
    public val format: Output<String>
        get() = javaResource.format().applyValue({ args0 -> args0 })

    /**
     * Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
     */
    public val refreshClosedReports: Output<Boolean>?
        get() = javaResource.refreshClosedReports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
     */
    public val reportName: Output<String>
        get() = javaResource.reportName().applyValue({ args0 -> args0 })

    /**
     * Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
     */
    public val reportVersioning: Output<String>?
        get() = javaResource.reportVersioning().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the existing S3 bucket to hold generated reports.
     */
    public val s3Bucket: Output<String>
        get() = javaResource.s3Bucket().applyValue({ args0 -> args0 })

    /**
     * Report path prefix. Limited to 256 characters.
     */
    public val s3Prefix: Output<String>?
        get() = javaResource.s3Prefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Region of the existing S3 bucket to hold generated reports.
     */
    public val s3Region: Output<String>
        get() = javaResource.s3Region().applyValue({ args0 -> args0 })

    /**
     * The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
     */
    public val timeUnit: Output<String>
        get() = javaResource.timeUnit().applyValue({ args0 -> args0 })
}

public object ReportDefinitionMapper : ResourceMapper<ReportDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cur.ReportDefinition::class == javaResource::class

    override fun map(javaResource: Resource): ReportDefinition = ReportDefinition(
        javaResource as
            com.pulumi.aws.cur.ReportDefinition,
    )
}

/**
 * @see [ReportDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReportDefinition].
 */
public suspend fun reportDefinition(
    name: String,
    block: suspend ReportDefinitionResourceBuilder.() -> Unit,
): ReportDefinition {
    val builder = ReportDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReportDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun reportDefinition(name: String): ReportDefinition {
    val builder = ReportDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
