@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cur.kotlin

import com.pulumi.aws.cur.ReportDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages Cost and Usage Report Definitions.
 * > *NOTE:* The AWS Cost and Usage Report service is only available in `us-east-1` currently.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cur.ReportDefinition;
 * import com.pulumi.aws.cur.ReportDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCurReportDefinition = new ReportDefinition("exampleCurReportDefinition", ReportDefinitionArgs.builder()
 *             .additionalArtifacts(
 *                 "REDSHIFT",
 *                 "QUICKSIGHT")
 *             .additionalSchemaElements(
 *                 "RESOURCES",
 *                 "SPLIT_COST_ALLOCATION_DATA")
 *             .compression("GZIP")
 *             .format("textORcsv")
 *             .reportName("example-cur-report-definition")
 *             .s3Bucket("example-bucket-name")
 *             .s3Region("us-east-1")
 *             .timeUnit("HOURLY")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Report Definitions using the `report_name`. For example:
 * ```sh
 *  $ pulumi import aws:cur/reportDefinition:ReportDefinition example_cur_report_definition example-cur-report-definition
 * ```
 * @property additionalArtifacts A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
 * @property additionalSchemaElements A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
 * @property compression Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
 * @property format Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
 * @property refreshClosedReports Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
 * @property reportName Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
 * @property reportVersioning Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
 * @property s3Bucket Name of the existing S3 bucket to hold generated reports.
 * @property s3Prefix Report path prefix. Limited to 256 characters.
 * @property s3Region Region of the existing S3 bucket to hold generated reports.
 * @property timeUnit The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
 */
public data class ReportDefinitionArgs(
    public val additionalArtifacts: Output<List<String>>? = null,
    public val additionalSchemaElements: Output<List<String>>? = null,
    public val compression: Output<String>? = null,
    public val format: Output<String>? = null,
    public val refreshClosedReports: Output<Boolean>? = null,
    public val reportName: Output<String>? = null,
    public val reportVersioning: Output<String>? = null,
    public val s3Bucket: Output<String>? = null,
    public val s3Prefix: Output<String>? = null,
    public val s3Region: Output<String>? = null,
    public val timeUnit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cur.ReportDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.cur.ReportDefinitionArgs =
        com.pulumi.aws.cur.ReportDefinitionArgs.builder()
            .additionalArtifacts(additionalArtifacts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .additionalSchemaElements(
                additionalSchemaElements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .compression(compression?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .refreshClosedReports(refreshClosedReports?.applyValue({ args0 -> args0 }))
            .reportName(reportName?.applyValue({ args0 -> args0 }))
            .reportVersioning(reportVersioning?.applyValue({ args0 -> args0 }))
            .s3Bucket(s3Bucket?.applyValue({ args0 -> args0 }))
            .s3Prefix(s3Prefix?.applyValue({ args0 -> args0 }))
            .s3Region(s3Region?.applyValue({ args0 -> args0 }))
            .timeUnit(timeUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportDefinitionArgs].
 */
@PulumiTagMarker
public class ReportDefinitionArgsBuilder internal constructor() {
    private var additionalArtifacts: Output<List<String>>? = null

    private var additionalSchemaElements: Output<List<String>>? = null

    private var compression: Output<String>? = null

    private var format: Output<String>? = null

    private var refreshClosedReports: Output<Boolean>? = null

    private var reportName: Output<String>? = null

    private var reportVersioning: Output<String>? = null

    private var s3Bucket: Output<String>? = null

    private var s3Prefix: Output<String>? = null

    private var s3Region: Output<String>? = null

    private var timeUnit: Output<String>? = null

    /**
     * @param value A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    @JvmName("snlvpkmfmdhmvbch")
    public suspend fun additionalArtifacts(`value`: Output<List<String>>) {
        this.additionalArtifacts = value
    }

    @JvmName("jjqqmhyrulylvuic")
    public suspend fun additionalArtifacts(vararg values: Output<String>) {
        this.additionalArtifacts = Output.all(values.asList())
    }

    /**
     * @param values A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    @JvmName("frwcuabhurabdmss")
    public suspend fun additionalArtifacts(values: List<Output<String>>) {
        this.additionalArtifacts = Output.all(values)
    }

    /**
     * @param value A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    @JvmName("pwetsormndktqpqi")
    public suspend fun additionalSchemaElements(`value`: Output<List<String>>) {
        this.additionalSchemaElements = value
    }

    @JvmName("pqoqsnlauufbuddl")
    public suspend fun additionalSchemaElements(vararg values: Output<String>) {
        this.additionalSchemaElements = Output.all(values.asList())
    }

    /**
     * @param values A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    @JvmName("vbgqfgwmxbidbtnt")
    public suspend fun additionalSchemaElements(values: List<Output<String>>) {
        this.additionalSchemaElements = Output.all(values)
    }

    /**
     * @param value Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
     */
    @JvmName("oxjsyckweldhvvul")
    public suspend fun compression(`value`: Output<String>) {
        this.compression = value
    }

    /**
     * @param value Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
     */
    @JvmName("eseroxvlylvqeoiv")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
     */
    @JvmName("xaybjlnpnbiwhbag")
    public suspend fun refreshClosedReports(`value`: Output<Boolean>) {
        this.refreshClosedReports = value
    }

    /**
     * @param value Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
     */
    @JvmName("ikoqdrgxxdpceilk")
    public suspend fun reportName(`value`: Output<String>) {
        this.reportName = value
    }

    /**
     * @param value Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
     */
    @JvmName("mmtwqienowoiprsu")
    public suspend fun reportVersioning(`value`: Output<String>) {
        this.reportVersioning = value
    }

    /**
     * @param value Name of the existing S3 bucket to hold generated reports.
     */
    @JvmName("spkkpipmfyvpkqjx")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value Report path prefix. Limited to 256 characters.
     */
    @JvmName("qbpbvxgklqmqojqr")
    public suspend fun s3Prefix(`value`: Output<String>) {
        this.s3Prefix = value
    }

    /**
     * @param value Region of the existing S3 bucket to hold generated reports.
     */
    @JvmName("vdtnyhkxnnfwrmce")
    public suspend fun s3Region(`value`: Output<String>) {
        this.s3Region = value
    }

    /**
     * @param value The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
     */
    @JvmName("lawynmsamyevsgci")
    public suspend fun timeUnit(`value`: Output<String>) {
        this.timeUnit = value
    }

    /**
     * @param value A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    @JvmName("ymempnugiwjdhgmj")
    public suspend fun additionalArtifacts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalArtifacts = mapped
    }

    /**
     * @param values A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    @JvmName("sgwhikcxfpctiabo")
    public suspend fun additionalArtifacts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalArtifacts = mapped
    }

    /**
     * @param value A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    @JvmName("ondyjxemuddyqnqf")
    public suspend fun additionalSchemaElements(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalSchemaElements = mapped
    }

    /**
     * @param values A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    @JvmName("gqmbanwxogtdxnjo")
    public suspend fun additionalSchemaElements(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalSchemaElements = mapped
    }

    /**
     * @param value Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
     */
    @JvmName("qgdywrlhmfabbovt")
    public suspend fun compression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
     */
    @JvmName("hwrmjxsjelkadmbf")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
     */
    @JvmName("dncpkjrlsuiycomy")
    public suspend fun refreshClosedReports(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshClosedReports = mapped
    }

    /**
     * @param value Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
     */
    @JvmName("crgrvkwkmrqaornq")
    public suspend fun reportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportName = mapped
    }

    /**
     * @param value Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
     */
    @JvmName("frcymxouctkgbjim")
    public suspend fun reportVersioning(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportVersioning = mapped
    }

    /**
     * @param value Name of the existing S3 bucket to hold generated reports.
     */
    @JvmName("agfbhyaqorasfpef")
    public suspend fun s3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value Report path prefix. Limited to 256 characters.
     */
    @JvmName("qityttaxhcgttmer")
    public suspend fun s3Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Prefix = mapped
    }

    /**
     * @param value Region of the existing S3 bucket to hold generated reports.
     */
    @JvmName("jponceehebhtdjfw")
    public suspend fun s3Region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Region = mapped
    }

    /**
     * @param value The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
     */
    @JvmName("wjofrravobuganey")
    public suspend fun timeUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeUnit = mapped
    }

    internal fun build(): ReportDefinitionArgs = ReportDefinitionArgs(
        additionalArtifacts = additionalArtifacts,
        additionalSchemaElements = additionalSchemaElements,
        compression = compression,
        format = format,
        refreshClosedReports = refreshClosedReports,
        reportName = reportName,
        reportVersioning = reportVersioning,
        s3Bucket = s3Bucket,
        s3Prefix = s3Prefix,
        s3Region = s3Region,
        timeUnit = timeUnit,
    )
}
