@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cur.kotlin.inputs

import com.pulumi.aws.cur.inputs.GetReportDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReportDefinition.
 * @property reportName Name of the report definition to match.
 */
public data class GetReportDefinitionPlainArgs(
    public val reportName: String,
) : ConvertibleToJava<com.pulumi.aws.cur.inputs.GetReportDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.aws.cur.inputs.GetReportDefinitionPlainArgs =
        com.pulumi.aws.cur.inputs.GetReportDefinitionPlainArgs.builder()
            .reportName(reportName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReportDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetReportDefinitionPlainArgsBuilder internal constructor() {
    private var reportName: String? = null

    /**
     * @param value Name of the report definition to match.
     */
    @JvmName("mkdiofvybjnfibae")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    internal fun build(): GetReportDefinitionPlainArgs = GetReportDefinitionPlainArgs(
        reportName = reportName ?: throw PulumiNullFieldException("reportName"),
    )
}
