@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cur.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getReportDefinition.
 * @property additionalArtifacts A list of additional artifacts.
 * @property additionalSchemaElements A list of schema elements.
 * @property compression Preferred format for report.
 * @property format Preferred compression format for report.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property refreshClosedReports If true reports are updated after they have been finalized.
 * @property reportName
 * @property reportVersioning Overwrite the previous version of each report or to deliver the report in addition to the previous versions.
 * @property s3Bucket Name of customer S3 bucket.
 * @property s3Prefix Preferred report path prefix.
 * @property s3Region Region of customer S3 bucket.
 * @property timeUnit Frequency on which report data are measured and displayed.
 */
public data class GetReportDefinitionResult(
    public val additionalArtifacts: List<String>,
    public val additionalSchemaElements: List<String>,
    public val compression: String,
    public val format: String,
    public val id: String,
    public val refreshClosedReports: Boolean,
    public val reportName: String,
    public val reportVersioning: String,
    public val s3Bucket: String,
    public val s3Prefix: String,
    public val s3Region: String,
    public val timeUnit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cur.outputs.GetReportDefinitionResult):
            GetReportDefinitionResult = GetReportDefinitionResult(
            additionalArtifacts = javaType.additionalArtifacts().map({ args0 -> args0 }),
            additionalSchemaElements = javaType.additionalSchemaElements().map({ args0 -> args0 }),
            compression = javaType.compression(),
            format = javaType.format(),
            id = javaType.id(),
            refreshClosedReports = javaType.refreshClosedReports(),
            reportName = javaType.reportName(),
            reportVersioning = javaType.reportVersioning(),
            s3Bucket = javaType.s3Bucket(),
            s3Prefix = javaType.s3Prefix(),
            s3Region = javaType.s3Region(),
            timeUnit = javaType.timeUnit(),
        )
    }
}
