@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dataexchange.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DataSet].
 */
@PulumiTagMarker
public class DataSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataSetArgs = DataSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataSetArgsBuilder.() -> Unit) {
        val builder = DataSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataSet {
        val builtJavaResource = com.pulumi.aws.dataexchange.DataSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataSet(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Data Exchange DataSets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dataexchange.DataSet;
 * import com.pulumi.aws.dataexchange.DataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .assetType("S3_SNAPSHOT")
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DataExchange DataSets using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:dataexchange/dataSet:DataSet example arn:aws:dataexchange:us-west-2:123456789012:data-sets/4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 *
 */
public class DataSet internal constructor(
    override val javaResource: com.pulumi.aws.dataexchange.DataSet,
) : KotlinCustomResource(javaResource, DataSetMapper) {
    /**
     * The Amazon Resource Name of this data set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type of asset that is added to a data set. Valid values are: `S3_SNAPSHOT`, `REDSHIFT_DATA_SHARE`, and `API_GATEWAY_API`.
     */
    public val assetType: Output<String>
        get() = javaResource.assetType().applyValue({ args0 -> args0 })

    /**
     * A description for the data set.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The name of the data set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DataSetMapper : ResourceMapper<DataSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dataexchange.DataSet::class == javaResource::class

    override fun map(javaResource: Resource): DataSet = DataSet(
        javaResource as
            com.pulumi.aws.dataexchange.DataSet,
    )
}

/**
 * @see [DataSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataSet].
 */
public suspend fun dataSet(name: String, block: suspend DataSetResourceBuilder.() -> Unit):
    DataSet {
    val builder = DataSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataSet(name: String): DataSet {
    val builder = DataSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
