@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dataexchange.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Revision].
 */
@PulumiTagMarker
public class RevisionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RevisionArgs = RevisionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RevisionArgsBuilder.() -> Unit) {
        val builder = RevisionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Revision {
        val builtJavaResource = com.pulumi.aws.dataexchange.Revision(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Revision(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Data Exchange Revisions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dataexchange.Revision;
 * import com.pulumi.aws.dataexchange.RevisionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Revision("example", RevisionArgs.builder()
 *             .dataSetId(aws_dataexchange_data_set.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DataExchange Revisions using their `data-set-id:revision-id`. For example:
 * ```sh
 *  $ pulumi import aws:dataexchange/revision:Revision example 4fa784c7-ccb4-4dbf-ba4f-02198320daa1:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 *
 */
public class Revision internal constructor(
    override val javaResource: com.pulumi.aws.dataexchange.Revision,
) : KotlinCustomResource(javaResource, RevisionMapper) {
    /**
     * The Amazon Resource Name of this data set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * An optional comment about the revision.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The dataset id.
     */
    public val dataSetId: Output<String>
        get() = javaResource.dataSetId().applyValue({ args0 -> args0 })

    /**
     * The Id of the revision.
     */
    public val revisionId: Output<String>
        get() = javaResource.revisionId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RevisionMapper : ResourceMapper<Revision> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dataexchange.Revision::class == javaResource::class

    override fun map(javaResource: Resource): Revision = Revision(
        javaResource as
            com.pulumi.aws.dataexchange.Revision,
    )
}

/**
 * @see [Revision].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Revision].
 */
public suspend fun revision(name: String, block: suspend RevisionResourceBuilder.() -> Unit):
    Revision {
    val builder = RevisionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Revision].
 * @param name The _unique_ name of the resulting resource.
 */
public fun revision(name: String): Revision {
    val builder = RevisionResourceBuilder()
    builder.name(name)
    return builder.build()
}
