@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin

import com.pulumi.aws.datapipeline.DatapipelineFunctions.getPipelineDefinitionPlain
import com.pulumi.aws.datapipeline.DatapipelineFunctions.getPipelinePlain
import com.pulumi.aws.datapipeline.kotlin.inputs.GetPipelineDefinitionParameterValue
import com.pulumi.aws.datapipeline.kotlin.inputs.GetPipelineDefinitionPlainArgs
import com.pulumi.aws.datapipeline.kotlin.inputs.GetPipelineDefinitionPlainArgsBuilder
import com.pulumi.aws.datapipeline.kotlin.inputs.GetPipelinePlainArgs
import com.pulumi.aws.datapipeline.kotlin.inputs.GetPipelinePlainArgsBuilder
import com.pulumi.aws.datapipeline.kotlin.outputs.GetPipelineDefinitionResult
import com.pulumi.aws.datapipeline.kotlin.outputs.GetPipelineResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.datapipeline.kotlin.outputs.GetPipelineDefinitionResult.Companion.toKotlin as getPipelineDefinitionResultToKotlin
import com.pulumi.aws.datapipeline.kotlin.outputs.GetPipelineResult.Companion.toKotlin as getPipelineResultToKotlin

public object DatapipelineFunctions {
    /**
     * Provides details about a specific DataPipeline Pipeline.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.datapipeline.DatapipelineFunctions;
     * import com.pulumi.aws.datapipeline.inputs.GetPipelineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DatapipelineFunctions.getPipeline(GetPipelineArgs.builder()
     *             .pipelineId("pipelineID")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPipeline.
     * @return A collection of values returned by getPipeline.
     */
    public suspend fun getPipeline(argument: GetPipelinePlainArgs): GetPipelineResult =
        getPipelineResultToKotlin(getPipelinePlain(argument.toJava()).await())

    /**
     * @see [getPipeline].
     * @param pipelineId ID of the pipeline.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getPipeline.
     */
    public suspend fun getPipeline(pipelineId: String, tags: Map<String, String>? = null):
        GetPipelineResult {
        val argument = GetPipelinePlainArgs(
            pipelineId = pipelineId,
            tags = tags,
        )
        return getPipelineResultToKotlin(getPipelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getPipeline].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;datapipeline&#46;kotlin&#46;inputs&#46;GetPipelinePlainArgs].
     * @return A collection of values returned by getPipeline.
     */
    public suspend fun getPipeline(argument: suspend GetPipelinePlainArgsBuilder.() -> Unit):
        GetPipelineResult {
        val builder = GetPipelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineResultToKotlin(getPipelinePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific DataPipeline Pipeline Definition.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.datapipeline.DatapipelineFunctions;
     * import com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DatapipelineFunctions.getPipelineDefinition(GetPipelineDefinitionArgs.builder()
     *             .pipelineId("pipelineID")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPipelineDefinition.
     * @return A collection of values returned by getPipelineDefinition.
     */
    public suspend fun getPipelineDefinition(argument: GetPipelineDefinitionPlainArgs):
        GetPipelineDefinitionResult =
        getPipelineDefinitionResultToKotlin(getPipelineDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getPipelineDefinition].
     * @param parameterValues Parameter values used in the pipeline definition. See below
     * @param pipelineId ID of the pipeline.
     * @return A collection of values returned by getPipelineDefinition.
     */
    public suspend
    fun getPipelineDefinition(
        parameterValues: List<GetPipelineDefinitionParameterValue>? = null,
        pipelineId: String,
    ): GetPipelineDefinitionResult {
        val argument = GetPipelineDefinitionPlainArgs(
            parameterValues = parameterValues,
            pipelineId = pipelineId,
        )
        return getPipelineDefinitionResultToKotlin(getPipelineDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPipelineDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;datapipeline&#46;kotlin&#46;inputs&#46;GetPipelineDefinitionPlainArgs].
     * @return A collection of values returned by getPipelineDefinition.
     */
    public suspend
    fun getPipelineDefinition(argument: suspend GetPipelineDefinitionPlainArgsBuilder.() -> Unit):
        GetPipelineDefinitionResult {
        val builder = GetPipelineDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineDefinitionResultToKotlin(getPipelineDefinitionPlain(builtArgument.toJava()).await())
    }
}
