@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Pipeline].
 */
@PulumiTagMarker
public class PipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineArgs = PipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineArgsBuilder.() -> Unit) {
        val builder = PipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Pipeline {
        val builtJavaResource = com.pulumi.aws.datapipeline.Pipeline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pipeline(builtJavaResource)
    }
}

/**
 * Provides a DataPipeline Pipeline resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datapipeline.Pipeline;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Pipeline("default");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datapipeline_pipeline` using the id (Pipeline ID). For example:
 * ```sh
 *  $ pulumi import aws:datapipeline/pipeline:Pipeline default df-1234567890
 * ```
 *
 */
public class Pipeline internal constructor(
    override val javaResource: com.pulumi.aws.datapipeline.Pipeline,
) : KotlinCustomResource(javaResource, PipelineMapper) {
    /**
     * The description of Pipeline.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of Pipeline.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PipelineMapper : ResourceMapper<Pipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datapipeline.Pipeline::class == javaResource::class

    override fun map(javaResource: Resource): Pipeline = Pipeline(
        javaResource as
            com.pulumi.aws.datapipeline.Pipeline,
    )
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipeline].
 */
public suspend fun pipeline(name: String, block: suspend PipelineResourceBuilder.() -> Unit):
    Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipeline(name: String): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
