@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin

import com.pulumi.aws.datapipeline.kotlin.outputs.PipelineDefinitionParameterObject
import com.pulumi.aws.datapipeline.kotlin.outputs.PipelineDefinitionParameterValue
import com.pulumi.aws.datapipeline.kotlin.outputs.PipelineDefinitionPipelineObject
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.datapipeline.kotlin.outputs.PipelineDefinitionParameterObject.Companion.toKotlin as pipelineDefinitionParameterObjectToKotlin
import com.pulumi.aws.datapipeline.kotlin.outputs.PipelineDefinitionParameterValue.Companion.toKotlin as pipelineDefinitionParameterValueToKotlin
import com.pulumi.aws.datapipeline.kotlin.outputs.PipelineDefinitionPipelineObject.Companion.toKotlin as pipelineDefinitionPipelineObjectToKotlin

/**
 * Builder for [PipelineDefinition].
 */
@PulumiTagMarker
public class PipelineDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineDefinitionArgs = PipelineDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineDefinitionArgsBuilder.() -> Unit) {
        val builder = PipelineDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PipelineDefinition {
        val builtJavaResource = com.pulumi.aws.datapipeline.PipelineDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PipelineDefinition(builtJavaResource)
    }
}

/**
 * Provides a DataPipeline Pipeline Definition resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datapipeline.Pipeline;
 * import com.pulumi.aws.datapipeline.PipelineDefinition;
 * import com.pulumi.aws.datapipeline.PipelineDefinitionArgs;
 * import com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Pipeline("default");
 *         var example = new PipelineDefinition("example", PipelineDefinitionArgs.builder()
 *             .pipelineId(default_.id())
 *             .pipelineObjects(
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("Default")
 *                     .name("Default")
 *                     .fields(PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                         .key("workerGroup")
 *                         .stringValue("workerGroup")
 *                         .build())
 *                     .build(),
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("Schedule")
 *                     .name("Schedule")
 *                     .fields(
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("startDateTime")
 *                             .stringValue("2012-12-12T00:00:00")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("type")
 *                             .stringValue("Schedule")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("period")
 *                             .stringValue("1 hour")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("endDateTime")
 *                             .stringValue("2012-12-21T18:00:00")
 *                             .build())
 *                     .build(),
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("SayHello")
 *                     .name("SayHello")
 *                     .fields(
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("type")
 *                             .stringValue("ShellCommandActivity")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("command")
 *                             .stringValue("echo hello")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("parent")
 *                             .stringValue("Default")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("schedule")
 *                             .stringValue("Schedule")
 *                             .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datapipeline_pipeline_definition` using the id. For example:
 * ```sh
 *  $ pulumi import aws:datapipeline/pipelineDefinition:PipelineDefinition example df-1234567890
 * ```
 *
 */
public class PipelineDefinition internal constructor(
    override val javaResource: com.pulumi.aws.datapipeline.PipelineDefinition,
) : KotlinCustomResource(javaResource, PipelineDefinitionMapper) {
    /**
     * Configuration block for the parameter objects used in the pipeline definition. See below
     */
    public val parameterObjects: Output<List<PipelineDefinitionParameterObject>>?
        get() = javaResource.parameterObjects().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        pipelineDefinitionParameterObjectToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block for the parameter values used in the pipeline definition. See below
     */
    public val parameterValues: Output<List<PipelineDefinitionParameterValue>>?
        get() = javaResource.parameterValues().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        pipelineDefinitionParameterValueToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * ID of the pipeline.
     */
    public val pipelineId: Output<String>
        get() = javaResource.pipelineId().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    public val pipelineObjects: Output<List<PipelineDefinitionPipelineObject>>
        get() = javaResource.pipelineObjects().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipelineDefinitionPipelineObjectToKotlin(args0) })
            })
        })
}

public object PipelineDefinitionMapper : ResourceMapper<PipelineDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datapipeline.PipelineDefinition::class == javaResource::class

    override fun map(javaResource: Resource): PipelineDefinition = PipelineDefinition(
        javaResource as
            com.pulumi.aws.datapipeline.PipelineDefinition,
    )
}

/**
 * @see [PipelineDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PipelineDefinition].
 */
public suspend fun pipelineDefinition(
    name: String,
    block: suspend PipelineDefinitionResourceBuilder.() -> Unit,
): PipelineDefinition {
    val builder = PipelineDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PipelineDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipelineDefinition(name: String): PipelineDefinition {
    val builder = PipelineDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
