@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin

import com.pulumi.aws.datapipeline.PipelineDefinitionArgs.builder
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionParameterObjectArgs
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionParameterObjectArgsBuilder
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionParameterValueArgs
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionParameterValueArgsBuilder
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionPipelineObjectArgs
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionPipelineObjectArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DataPipeline Pipeline Definition resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datapipeline.Pipeline;
 * import com.pulumi.aws.datapipeline.PipelineDefinition;
 * import com.pulumi.aws.datapipeline.PipelineDefinitionArgs;
 * import com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Pipeline("default");
 *         var example = new PipelineDefinition("example", PipelineDefinitionArgs.builder()
 *             .pipelineId(default_.id())
 *             .pipelineObjects(
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("Default")
 *                     .name("Default")
 *                     .fields(PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                         .key("workerGroup")
 *                         .stringValue("workerGroup")
 *                         .build())
 *                     .build(),
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("Schedule")
 *                     .name("Schedule")
 *                     .fields(
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("startDateTime")
 *                             .stringValue("2012-12-12T00:00:00")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("type")
 *                             .stringValue("Schedule")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("period")
 *                             .stringValue("1 hour")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("endDateTime")
 *                             .stringValue("2012-12-21T18:00:00")
 *                             .build())
 *                     .build(),
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("SayHello")
 *                     .name("SayHello")
 *                     .fields(
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("type")
 *                             .stringValue("ShellCommandActivity")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("command")
 *                             .stringValue("echo hello")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("parent")
 *                             .stringValue("Default")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("schedule")
 *                             .stringValue("Schedule")
 *                             .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datapipeline_pipeline_definition` using the id. For example:
 * ```sh
 *  $ pulumi import aws:datapipeline/pipelineDefinition:PipelineDefinition example df-1234567890
 * ```
 * @property parameterObjects Configuration block for the parameter objects used in the pipeline definition. See below
 * @property parameterValues Configuration block for the parameter values used in the pipeline definition. See below
 * @property pipelineId ID of the pipeline.
 * @property pipelineObjects Configuration block for the objects that define the pipeline. See below
 * The following arguments are optional:
 */
public data class PipelineDefinitionArgs(
    public val parameterObjects: Output<List<PipelineDefinitionParameterObjectArgs>>? = null,
    public val parameterValues: Output<List<PipelineDefinitionParameterValueArgs>>? = null,
    public val pipelineId: Output<String>? = null,
    public val pipelineObjects: Output<List<PipelineDefinitionPipelineObjectArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.PipelineDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.datapipeline.PipelineDefinitionArgs =
        com.pulumi.aws.datapipeline.PipelineDefinitionArgs.builder()
            .parameterObjects(
                parameterObjects?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parameterValues(
                parameterValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pipelineId(pipelineId?.applyValue({ args0 -> args0 }))
            .pipelineObjects(
                pipelineObjects?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelineDefinitionArgs].
 */
@PulumiTagMarker
public class PipelineDefinitionArgsBuilder internal constructor() {
    private var parameterObjects: Output<List<PipelineDefinitionParameterObjectArgs>>? = null

    private var parameterValues: Output<List<PipelineDefinitionParameterValueArgs>>? = null

    private var pipelineId: Output<String>? = null

    private var pipelineObjects: Output<List<PipelineDefinitionPipelineObjectArgs>>? = null

    /**
     * @param value Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("eunhanqpkjyqyvol")
    public suspend
    fun parameterObjects(`value`: Output<List<PipelineDefinitionParameterObjectArgs>>) {
        this.parameterObjects = value
    }

    @JvmName("jqccostwrnvwrqsl")
    public suspend fun parameterObjects(
        vararg
        values: Output<PipelineDefinitionParameterObjectArgs>,
    ) {
        this.parameterObjects = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("pbudiobhcugedujb")
    public suspend fun parameterObjects(values: List<Output<PipelineDefinitionParameterObjectArgs>>) {
        this.parameterObjects = Output.all(values)
    }

    /**
     * @param value Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("lnrxinmvutpigxgf")
    public suspend fun parameterValues(`value`: Output<List<PipelineDefinitionParameterValueArgs>>) {
        this.parameterValues = value
    }

    @JvmName("viblhtxdcyolitbf")
    public suspend fun parameterValues(vararg values: Output<PipelineDefinitionParameterValueArgs>) {
        this.parameterValues = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("kuxtlsjsexlpwrdk")
    public suspend fun parameterValues(values: List<Output<PipelineDefinitionParameterValueArgs>>) {
        this.parameterValues = Output.all(values)
    }

    /**
     * @param value ID of the pipeline.
     */
    @JvmName("ewyrggpywocyrckf")
    public suspend fun pipelineId(`value`: Output<String>) {
        this.pipelineId = value
    }

    /**
     * @param value Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("afygitbqjfygakgo")
    public suspend fun pipelineObjects(`value`: Output<List<PipelineDefinitionPipelineObjectArgs>>) {
        this.pipelineObjects = value
    }

    @JvmName("fbvrvnyimnypmnhm")
    public suspend fun pipelineObjects(vararg values: Output<PipelineDefinitionPipelineObjectArgs>) {
        this.pipelineObjects = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("mkycusbsbaoghfrp")
    public suspend fun pipelineObjects(values: List<Output<PipelineDefinitionPipelineObjectArgs>>) {
        this.pipelineObjects = Output.all(values)
    }

    /**
     * @param value Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("yfwuxhoxkfrrqrln")
    public suspend fun parameterObjects(`value`: List<PipelineDefinitionParameterObjectArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterObjects = mapped
    }

    /**
     * @param argument Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("yphwncovrithnbvo")
    public suspend
    fun parameterObjects(argument: List<suspend PipelineDefinitionParameterObjectArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterObjects = mapped
    }

    /**
     * @param argument Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("qxcxptgnbmlcnxvm")
    public suspend fun parameterObjects(
        vararg
        argument: suspend PipelineDefinitionParameterObjectArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterObjects = mapped
    }

    /**
     * @param argument Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("kfpvtkywvgnulrmg")
    public suspend
    fun parameterObjects(argument: suspend PipelineDefinitionParameterObjectArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineDefinitionParameterObjectArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameterObjects = mapped
    }

    /**
     * @param values Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("vfaacpfpwwggxoyx")
    public suspend fun parameterObjects(vararg values: PipelineDefinitionParameterObjectArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterObjects = mapped
    }

    /**
     * @param value Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("pywnyybgxulnqkxe")
    public suspend fun parameterValues(`value`: List<PipelineDefinitionParameterValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterValues = mapped
    }

    /**
     * @param argument Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("kbdfrqbueiyqmnao")
    public suspend
    fun parameterValues(argument: List<suspend PipelineDefinitionParameterValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterValues = mapped
    }

    /**
     * @param argument Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("jiljhtkuddbgdlon")
    public suspend fun parameterValues(
        vararg
        argument: suspend PipelineDefinitionParameterValueArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterValues = mapped
    }

    /**
     * @param argument Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("yylyrhuawdmxurcc")
    public suspend
    fun parameterValues(argument: suspend PipelineDefinitionParameterValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineDefinitionParameterValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameterValues = mapped
    }

    /**
     * @param values Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("ieemeufmxfgrahlw")
    public suspend fun parameterValues(vararg values: PipelineDefinitionParameterValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValues = mapped
    }

    /**
     * @param value ID of the pipeline.
     */
    @JvmName("obacextnbhakfjav")
    public suspend fun pipelineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineId = mapped
    }

    /**
     * @param value Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("vhecktsdfhhpqmch")
    public suspend fun pipelineObjects(`value`: List<PipelineDefinitionPipelineObjectArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineObjects = mapped
    }

    /**
     * @param argument Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("cudjoafixcrrsyca")
    public suspend
    fun pipelineObjects(argument: List<suspend PipelineDefinitionPipelineObjectArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionPipelineObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineObjects = mapped
    }

    /**
     * @param argument Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("sskocyucssdjwkbr")
    public suspend fun pipelineObjects(
        vararg
        argument: suspend PipelineDefinitionPipelineObjectArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionPipelineObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineObjects = mapped
    }

    /**
     * @param argument Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("dfujgrnjcbmjpgei")
    public suspend
    fun pipelineObjects(argument: suspend PipelineDefinitionPipelineObjectArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineDefinitionPipelineObjectArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pipelineObjects = mapped
    }

    /**
     * @param values Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("vqmuneceikskttiq")
    public suspend fun pipelineObjects(vararg values: PipelineDefinitionPipelineObjectArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelineObjects = mapped
    }

    internal fun build(): PipelineDefinitionArgs = PipelineDefinitionArgs(
        parameterObjects = parameterObjects,
        parameterValues = parameterValues,
        pipelineId = pipelineId,
        pipelineObjects = pipelineObjects,
    )
}
