@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.inputs

import com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterObjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attributes Configuration block for attributes of the parameter object. See below
 * @property id ID of the parameter object.
 */
public data class PipelineDefinitionParameterObjectArgs(
    public val attributes: Output<List<PipelineDefinitionParameterObjectAttributeArgs>>? = null,
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterObjectArgs> {
    override fun toJava(): com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterObjectArgs =
        com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterObjectArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineDefinitionParameterObjectArgs].
 */
@PulumiTagMarker
public class PipelineDefinitionParameterObjectArgsBuilder internal constructor() {
    private var attributes: Output<List<PipelineDefinitionParameterObjectAttributeArgs>>? = null

    private var id: Output<String>? = null

    /**
     * @param value Configuration block for attributes of the parameter object. See below
     */
    @JvmName("onmslhvultfuqeou")
    public suspend
    fun attributes(`value`: Output<List<PipelineDefinitionParameterObjectAttributeArgs>>) {
        this.attributes = value
    }

    @JvmName("rgekfnxkqdvvoftk")
    public suspend fun attributes(
        vararg
        values: Output<PipelineDefinitionParameterObjectAttributeArgs>,
    ) {
        this.attributes = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for attributes of the parameter object. See below
     */
    @JvmName("fwkhgnwsvsmrurwd")
    public suspend
    fun attributes(values: List<Output<PipelineDefinitionParameterObjectAttributeArgs>>) {
        this.attributes = Output.all(values)
    }

    /**
     * @param value ID of the parameter object.
     */
    @JvmName("yupfqdmjhyslcvtb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Configuration block for attributes of the parameter object. See below
     */
    @JvmName("kptgukghojmafegj")
    public suspend fun attributes(`value`: List<PipelineDefinitionParameterObjectAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument Configuration block for attributes of the parameter object. See below
     */
    @JvmName("lwnypwfisvcvcbgm")
    public suspend
    fun attributes(argument: List<suspend PipelineDefinitionParameterObjectAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterObjectAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument Configuration block for attributes of the parameter object. See below
     */
    @JvmName("cvymaifqifytsfpv")
    public suspend fun attributes(
        vararg
        argument: suspend PipelineDefinitionParameterObjectAttributeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterObjectAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument Configuration block for attributes of the parameter object. See below
     */
    @JvmName("fdygtvblwamveklq")
    public suspend
    fun attributes(argument: suspend PipelineDefinitionParameterObjectAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineDefinitionParameterObjectAttributeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param values Configuration block for attributes of the parameter object. See below
     */
    @JvmName("lpojjikfqdkigfpv")
    public suspend fun attributes(vararg values: PipelineDefinitionParameterObjectAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value ID of the parameter object.
     */
    @JvmName("galmaxjtsohgvftc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): PipelineDefinitionParameterObjectArgs =
        PipelineDefinitionParameterObjectArgs(
            attributes = attributes,
            id = id ?: throw PulumiNullFieldException("id"),
        )
}
