@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.inputs

import com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterObjectAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Field identifier.
 * @property stringValue Field value, expressed as a String.
 */
public data class PipelineDefinitionParameterObjectAttributeArgs(
    public val key: Output<String>,
    public val stringValue: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterObjectAttributeArgs> {
    override fun toJava():
        com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterObjectAttributeArgs =
        com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterObjectAttributeArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .stringValue(stringValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineDefinitionParameterObjectAttributeArgs].
 */
@PulumiTagMarker
public class PipelineDefinitionParameterObjectAttributeArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var stringValue: Output<String>? = null

    /**
     * @param value Field identifier.
     */
    @JvmName("nxqbsvpkefjduyln")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Field value, expressed as a String.
     */
    @JvmName("lhphpjcrvgfpjqur")
    public suspend fun stringValue(`value`: Output<String>) {
        this.stringValue = value
    }

    /**
     * @param value Field identifier.
     */
    @JvmName("ejjcdiunfshifqrr")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Field value, expressed as a String.
     */
    @JvmName("hlulllamolbnmcym")
    public suspend fun stringValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringValue = mapped
    }

    internal fun build(): PipelineDefinitionParameterObjectAttributeArgs =
        PipelineDefinitionParameterObjectAttributeArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            stringValue = stringValue ?: throw PulumiNullFieldException("stringValue"),
        )
}
