@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPipelineDefinition.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property parameterObjects Parameter objects used in the pipeline definition. See below
 * @property parameterValues Parameter values used in the pipeline definition. See below
 * @property pipelineId
 * @property pipelineObjects Objects defined in the pipeline. See below
 */
public data class GetPipelineDefinitionResult(
    public val id: String,
    public val parameterObjects: List<GetPipelineDefinitionParameterObject>,
    public val parameterValues: List<GetPipelineDefinitionParameterValue>? = null,
    public val pipelineId: String,
    public val pipelineObjects: List<GetPipelineDefinitionPipelineObject>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datapipeline.outputs.GetPipelineDefinitionResult):
            GetPipelineDefinitionResult = GetPipelineDefinitionResult(
            id = javaType.id(),
            parameterObjects = javaType.parameterObjects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.datapipeline.kotlin.outputs.GetPipelineDefinitionParameterObject.Companion.toKotlin(args0)
                })
            }),
            parameterValues = javaType.parameterValues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.datapipeline.kotlin.outputs.GetPipelineDefinitionParameterValue.Companion.toKotlin(args0)
                })
            }),
            pipelineId = javaType.pipelineId(),
            pipelineObjects = javaType.pipelineObjects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.datapipeline.kotlin.outputs.GetPipelineDefinitionPipelineObject.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
