@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getPipeline.
 * @property description Description of Pipeline.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of Pipeline.
 * @property pipelineId
 * @property tags Map of tags assigned to the resource.
 */
public data class GetPipelineResult(
    public val description: String,
    public val id: String,
    public val name: String,
    public val pipelineId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datapipeline.outputs.GetPipelineResult):
            GetPipelineResult = GetPipelineResult(
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            pipelineId = javaType.pipelineId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
