@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Agent].
 */
@PulumiTagMarker
public class AgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentArgs = AgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentArgsBuilder.() -> Unit) {
        val builder = AgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Agent {
        val builtJavaResource = com.pulumi.aws.datasync.Agent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Agent(builtJavaResource)
    }
}

/**
 * Manages an AWS DataSync Agent deployed on premises.
 * > **NOTE:** One of `activation_key` or `ip_address` must be provided for resource creation (agent activation). Neither is required for resource import. If using `ip_address`, this provider must be able to make an HTTP (port 80) GET request to the specified IP address from where it is running. The agent will turn off that HTTP server after activation.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.Agent;
 * import com.pulumi.aws.datasync.AgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Agent("example", AgentArgs.builder()
 *             .ipAddress("1.2.3.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_agent` using the DataSync Agent Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/agent:Agent example arn:aws:datasync:us-east-1:123456789012:agent/agent-12345678901234567
 * ```
 *
 */
public class Agent internal constructor(
    override val javaResource: com.pulumi.aws.datasync.Agent,
) : KotlinCustomResource(javaResource, AgentMapper) {
    /**
     * DataSync Agent activation key during resource creation. Conflicts with `ip_address`. If an `ip_address` is provided instead, the provider will retrieve the `activation_key` as part of the resource creation.
     */
    public val activationKey: Output<String>
        get() = javaResource.activationKey().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the DataSync Agent.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * DataSync Agent IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. DataSync Agent must be accessible on port 80 from where the provider is running.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * Name of the DataSync Agent.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The IP address of the VPC endpoint the agent should connect to when retrieving an activation key during resource creation. Conflicts with `activation_key`.
     */
    public val privateLinkEndpoint: Output<String>
        get() = javaResource.privateLinkEndpoint().applyValue({ args0 -> args0 })

    /**
     * The ARNs of the security groups used to protect your data transfer task subnets.
     */
    public val securityGroupArns: Output<List<String>>?
        get() = javaResource.securityGroupArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
     */
    public val subnetArns: Output<List<String>>?
        get() = javaResource.subnetArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Agent. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the VPC (virtual private cloud) endpoint that the agent has access to.
     */
    public val vpcEndpointId: Output<String>?
        get() = javaResource.vpcEndpointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AgentMapper : ResourceMapper<Agent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.Agent::class == javaResource::class

    override fun map(javaResource: Resource): Agent = Agent(
        javaResource as
            com.pulumi.aws.datasync.Agent,
    )
}

/**
 * @see [Agent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Agent].
 */
public suspend fun agent(name: String, block: suspend AgentResourceBuilder.() -> Unit): Agent {
    val builder = AgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Agent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agent(name: String): Agent {
    val builder = AgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
