@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.AgentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS DataSync Agent deployed on premises.
 * > **NOTE:** One of `activation_key` or `ip_address` must be provided for resource creation (agent activation). Neither is required for resource import. If using `ip_address`, this provider must be able to make an HTTP (port 80) GET request to the specified IP address from where it is running. The agent will turn off that HTTP server after activation.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.Agent;
 * import com.pulumi.aws.datasync.AgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Agent("example", AgentArgs.builder()
 *             .ipAddress("1.2.3.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_agent` using the DataSync Agent Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/agent:Agent example arn:aws:datasync:us-east-1:123456789012:agent/agent-12345678901234567
 * ```
 * @property activationKey DataSync Agent activation key during resource creation. Conflicts with `ip_address`. If an `ip_address` is provided instead, the provider will retrieve the `activation_key` as part of the resource creation.
 * @property ipAddress DataSync Agent IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. DataSync Agent must be accessible on port 80 from where the provider is running.
 * @property name Name of the DataSync Agent.
 * @property privateLinkEndpoint The IP address of the VPC endpoint the agent should connect to when retrieving an activation key during resource creation. Conflicts with `activation_key`.
 * @property securityGroupArns The ARNs of the security groups used to protect your data transfer task subnets.
 * @property subnetArns The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Agent. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcEndpointId The ID of the VPC (virtual private cloud) endpoint that the agent has access to.
 */
public data class AgentArgs(
    public val activationKey: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateLinkEndpoint: Output<String>? = null,
    public val securityGroupArns: Output<List<String>>? = null,
    public val subnetArns: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcEndpointId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.AgentArgs> {
    override fun toJava(): com.pulumi.aws.datasync.AgentArgs =
        com.pulumi.aws.datasync.AgentArgs.builder()
            .activationKey(activationKey?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateLinkEndpoint(privateLinkEndpoint?.applyValue({ args0 -> args0 }))
            .securityGroupArns(securityGroupArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetArns(subnetArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentArgs].
 */
@PulumiTagMarker
public class AgentArgsBuilder internal constructor() {
    private var activationKey: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var name: Output<String>? = null

    private var privateLinkEndpoint: Output<String>? = null

    private var securityGroupArns: Output<List<String>>? = null

    private var subnetArns: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcEndpointId: Output<String>? = null

    /**
     * @param value DataSync Agent activation key during resource creation. Conflicts with `ip_address`. If an `ip_address` is provided instead, the provider will retrieve the `activation_key` as part of the resource creation.
     */
    @JvmName("cdssobofxdhemxxs")
    public suspend fun activationKey(`value`: Output<String>) {
        this.activationKey = value
    }

    /**
     * @param value DataSync Agent IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. DataSync Agent must be accessible on port 80 from where the provider is running.
     */
    @JvmName("vtextuypxrahobwd")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value Name of the DataSync Agent.
     */
    @JvmName("qotfwadtaxywotkj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IP address of the VPC endpoint the agent should connect to when retrieving an activation key during resource creation. Conflicts with `activation_key`.
     */
    @JvmName("iiyspsvuacxamilk")
    public suspend fun privateLinkEndpoint(`value`: Output<String>) {
        this.privateLinkEndpoint = value
    }

    /**
     * @param value The ARNs of the security groups used to protect your data transfer task subnets.
     */
    @JvmName("tnqslhwqwunndpyi")
    public suspend fun securityGroupArns(`value`: Output<List<String>>) {
        this.securityGroupArns = value
    }

    @JvmName("bwteifetagqidjlq")
    public suspend fun securityGroupArns(vararg values: Output<String>) {
        this.securityGroupArns = Output.all(values.asList())
    }

    /**
     * @param values The ARNs of the security groups used to protect your data transfer task subnets.
     */
    @JvmName("frmlrusqstjvqdwu")
    public suspend fun securityGroupArns(values: List<Output<String>>) {
        this.securityGroupArns = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
     */
    @JvmName("tsdepkpukxuyibaj")
    public suspend fun subnetArns(`value`: Output<List<String>>) {
        this.subnetArns = value
    }

    @JvmName("iwaoiwapfqrtbvkt")
    public suspend fun subnetArns(vararg values: Output<String>) {
        this.subnetArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
     */
    @JvmName("vhmfwjaotcjqhggo")
    public suspend fun subnetArns(values: List<Output<String>>) {
        this.subnetArns = Output.all(values)
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Agent. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bjipfuxrimwaaqkp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC (virtual private cloud) endpoint that the agent has access to.
     */
    @JvmName("ngxtdarotdjwsbaq")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value DataSync Agent activation key during resource creation. Conflicts with `ip_address`. If an `ip_address` is provided instead, the provider will retrieve the `activation_key` as part of the resource creation.
     */
    @JvmName("pngbmutnbsabehub")
    public suspend fun activationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activationKey = mapped
    }

    /**
     * @param value DataSync Agent IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. DataSync Agent must be accessible on port 80 from where the provider is running.
     */
    @JvmName("jxicunklmexqmohu")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value Name of the DataSync Agent.
     */
    @JvmName("ywlnpnmcoysdciae")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IP address of the VPC endpoint the agent should connect to when retrieving an activation key during resource creation. Conflicts with `activation_key`.
     */
    @JvmName("lvqjkwalmwpgwdel")
    public suspend fun privateLinkEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkEndpoint = mapped
    }

    /**
     * @param value The ARNs of the security groups used to protect your data transfer task subnets.
     */
    @JvmName("lgtapsrhyisooelo")
    public suspend fun securityGroupArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param values The ARNs of the security groups used to protect your data transfer task subnets.
     */
    @JvmName("nxelceknofwejaha")
    public suspend fun securityGroupArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param value The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
     */
    @JvmName("chggvntqkebmmmai")
    public suspend fun subnetArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetArns = mapped
    }

    /**
     * @param values The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
     */
    @JvmName("dprkhqtjddpqedot")
    public suspend fun subnetArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetArns = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Agent. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wcaqfshyjjuawajp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Agent. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pafekxxrmvsxxqyi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC (virtual private cloud) endpoint that the agent has access to.
     */
    @JvmName("yfpiqpxfgeqwipfq")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    internal fun build(): AgentArgs = AgentArgs(
        activationKey = activationKey,
        ipAddress = ipAddress,
        name = name,
        privateLinkEndpoint = privateLinkEndpoint,
        securityGroupArns = securityGroupArns,
        subnetArns = subnetArns,
        tags = tags,
        vpcEndpointId = vpcEndpointId,
    )
}
