@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.EfsLocationEc2Config
import com.pulumi.aws.datasync.kotlin.outputs.EfsLocationEc2Config.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EfsLocation].
 */
@PulumiTagMarker
public class EfsLocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EfsLocationArgs = EfsLocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EfsLocationArgsBuilder.() -> Unit) {
        val builder = EfsLocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EfsLocation {
        val builtJavaResource = com.pulumi.aws.datasync.EfsLocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EfsLocation(builtJavaResource)
    }
}

/**
 * Manages an AWS DataSync EFS Location.
 * > **NOTE:** The EFS File System must have a mounted EFS Mount Target before creating this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.EfsLocation;
 * import com.pulumi.aws.datasync.EfsLocationArgs;
 * import com.pulumi.aws.datasync.inputs.EfsLocationEc2ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EfsLocation("example", EfsLocationArgs.builder()
 *             .efsFileSystemArn(aws_efs_mount_target.example().file_system_arn())
 *             .ec2Config(EfsLocationEc2ConfigArgs.builder()
 *                 .securityGroupArns(aws_security_group.example().arn())
 *                 .subnetArn(aws_subnet.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_efs` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/efsLocation:EfsLocation example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 *
 */
public class EfsLocation internal constructor(
    override val javaResource: com.pulumi.aws.datasync.EfsLocation,
) : KotlinCustomResource(javaResource, EfsLocationMapper) {
    /**
     * Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
     */
    public val accessPointArn: Output<String>?
        get() = javaResource.accessPointArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block containing EC2 configurations for connecting to the EFS File System.
     */
    public val ec2Config: Output<EfsLocationEc2Config>
        get() = javaResource.ec2Config().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Amazon Resource Name (ARN) of EFS File System.
     */
    public val efsFileSystemArn: Output<String>
        get() = javaResource.efsFileSystemArn().applyValue({ args0 -> args0 })

    /**
     * Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
     */
    public val fileSystemAccessRoleArn: Output<String>?
        get() = javaResource.fileSystemAccessRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
     */
    public val inTransitEncryption: Output<String>?
        get() = javaResource.inTransitEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subdirectory to perform actions as source or destination. Default `/`.
     */
    public val subdirectory: Output<String>?
        get() = javaResource.subdirectory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object EfsLocationMapper : ResourceMapper<EfsLocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.EfsLocation::class == javaResource::class

    override fun map(javaResource: Resource): EfsLocation = EfsLocation(
        javaResource as
            com.pulumi.aws.datasync.EfsLocation,
    )
}

/**
 * @see [EfsLocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EfsLocation].
 */
public suspend fun efsLocation(name: String, block: suspend EfsLocationResourceBuilder.() -> Unit):
    EfsLocation {
    val builder = EfsLocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EfsLocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun efsLocation(name: String): EfsLocation {
    val builder = EfsLocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
