@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.EfsLocationArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.EfsLocationEc2ConfigArgs
import com.pulumi.aws.datasync.kotlin.inputs.EfsLocationEc2ConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS DataSync EFS Location.
 * > **NOTE:** The EFS File System must have a mounted EFS Mount Target before creating this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.EfsLocation;
 * import com.pulumi.aws.datasync.EfsLocationArgs;
 * import com.pulumi.aws.datasync.inputs.EfsLocationEc2ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EfsLocation("example", EfsLocationArgs.builder()
 *             .efsFileSystemArn(aws_efs_mount_target.example().file_system_arn())
 *             .ec2Config(EfsLocationEc2ConfigArgs.builder()
 *                 .securityGroupArns(aws_security_group.example().arn())
 *                 .subnetArn(aws_subnet.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_efs` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/efsLocation:EfsLocation example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property accessPointArn Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
 * @property ec2Config Configuration block containing EC2 configurations for connecting to the EFS File System.
 * @property efsFileSystemArn Amazon Resource Name (ARN) of EFS File System.
 * @property fileSystemAccessRoleArn Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
 * @property inTransitEncryption Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
 * @property subdirectory Subdirectory to perform actions as source or destination. Default `/`.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EfsLocationArgs(
    public val accessPointArn: Output<String>? = null,
    public val ec2Config: Output<EfsLocationEc2ConfigArgs>? = null,
    public val efsFileSystemArn: Output<String>? = null,
    public val fileSystemAccessRoleArn: Output<String>? = null,
    public val inTransitEncryption: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.EfsLocationArgs> {
    override fun toJava(): com.pulumi.aws.datasync.EfsLocationArgs =
        com.pulumi.aws.datasync.EfsLocationArgs.builder()
            .accessPointArn(accessPointArn?.applyValue({ args0 -> args0 }))
            .ec2Config(ec2Config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .efsFileSystemArn(efsFileSystemArn?.applyValue({ args0 -> args0 }))
            .fileSystemAccessRoleArn(fileSystemAccessRoleArn?.applyValue({ args0 -> args0 }))
            .inTransitEncryption(inTransitEncryption?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EfsLocationArgs].
 */
@PulumiTagMarker
public class EfsLocationArgsBuilder internal constructor() {
    private var accessPointArn: Output<String>? = null

    private var ec2Config: Output<EfsLocationEc2ConfigArgs>? = null

    private var efsFileSystemArn: Output<String>? = null

    private var fileSystemAccessRoleArn: Output<String>? = null

    private var inTransitEncryption: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
     */
    @JvmName("rrfhamavbaldnxml")
    public suspend fun accessPointArn(`value`: Output<String>) {
        this.accessPointArn = value
    }

    /**
     * @param value Configuration block containing EC2 configurations for connecting to the EFS File System.
     */
    @JvmName("kpuxsfxrxgxfluom")
    public suspend fun ec2Config(`value`: Output<EfsLocationEc2ConfigArgs>) {
        this.ec2Config = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of EFS File System.
     */
    @JvmName("olpasxcrrsbthqqa")
    public suspend fun efsFileSystemArn(`value`: Output<String>) {
        this.efsFileSystemArn = value
    }

    /**
     * @param value Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
     */
    @JvmName("cihpvcneekmjafif")
    public suspend fun fileSystemAccessRoleArn(`value`: Output<String>) {
        this.fileSystemAccessRoleArn = value
    }

    /**
     * @param value Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
     */
    @JvmName("wbphptsmkwyyguwv")
    public suspend fun inTransitEncryption(`value`: Output<String>) {
        this.inTransitEncryption = value
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Default `/`.
     */
    @JvmName("qudnxhnhgipithuk")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nhmwfgwiwsuleeqv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
     */
    @JvmName("vtxucjxbtdjhwmyo")
    public suspend fun accessPointArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPointArn = mapped
    }

    /**
     * @param value Configuration block containing EC2 configurations for connecting to the EFS File System.
     */
    @JvmName("xjigpwhwlmbctxxr")
    public suspend fun ec2Config(`value`: EfsLocationEc2ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2Config = mapped
    }

    /**
     * @param argument Configuration block containing EC2 configurations for connecting to the EFS File System.
     */
    @JvmName("hffbsktabibytbtr")
    public suspend fun ec2Config(argument: suspend EfsLocationEc2ConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EfsLocationEc2ConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ec2Config = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of EFS File System.
     */
    @JvmName("wskjloxlusfaixbr")
    public suspend fun efsFileSystemArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efsFileSystemArn = mapped
    }

    /**
     * @param value Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
     */
    @JvmName("aminaqlwavdgcsdy")
    public suspend fun fileSystemAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemAccessRoleArn = mapped
    }

    /**
     * @param value Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
     */
    @JvmName("rhbwvpndlldxjhcr")
    public suspend fun inTransitEncryption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inTransitEncryption = mapped
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Default `/`.
     */
    @JvmName("akotshxpmdoadeys")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uuweonmbpkrkqtsd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fhxsleotceaddcwe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EfsLocationArgs = EfsLocationArgs(
        accessPointArn = accessPointArn,
        ec2Config = ec2Config,
        efsFileSystemArn = efsFileSystemArn,
        fileSystemAccessRoleArn = fileSystemAccessRoleArn,
        inTransitEncryption = inTransitEncryption,
        subdirectory = subdirectory,
        tags = tags,
    )
}
