@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationAzureBlobArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.LocationAzureBlobSasConfigurationArgs
import com.pulumi.aws.datasync.kotlin.inputs.LocationAzureBlobSasConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Microsoft Azure Blob Storage Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationAzureBlob;
 * import com.pulumi.aws.datasync.LocationAzureBlobArgs;
 * import com.pulumi.aws.datasync.inputs.LocationAzureBlobSasConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationAzureBlob("example", LocationAzureBlobArgs.builder()
 *             .agentArns(aws_datasync_agent.example().arn())
 *             .authenticationType("SAS")
 *             .containerUrl("https://example.com/path")
 *             .sasConfiguration(LocationAzureBlobSasConfigurationArgs.builder()
 *                 .token("sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_azure_blob` using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/locationAzureBlob:LocationAzureBlob example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property accessTier The access tier that you want your objects or files transferred into. Valid values: `HOT`, `COOL` and `ARCHIVE`. Default: `HOT`.
 * @property agentArns A list of DataSync Agent ARNs with which this location will be associated.
 * @property authenticationType The authentication method DataSync uses to access your Azure Blob Storage. Valid values: `SAS`.
 * @property blobType The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Valid values: `BLOB`. Default: `BLOB`.
 * @property containerUrl The URL of the Azure Blob Storage container involved in your transfer.
 * @property sasConfiguration The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
 * @property subdirectory Path segments if you want to limit your transfer to a virtual directory in the container.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LocationAzureBlobArgs(
    public val accessTier: Output<String>? = null,
    public val agentArns: Output<List<String>>? = null,
    public val authenticationType: Output<String>? = null,
    public val blobType: Output<String>? = null,
    public val containerUrl: Output<String>? = null,
    public val sasConfiguration: Output<LocationAzureBlobSasConfigurationArgs>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationAzureBlobArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationAzureBlobArgs =
        com.pulumi.aws.datasync.LocationAzureBlobArgs.builder()
            .accessTier(accessTier?.applyValue({ args0 -> args0 }))
            .agentArns(agentArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .blobType(blobType?.applyValue({ args0 -> args0 }))
            .containerUrl(containerUrl?.applyValue({ args0 -> args0 }))
            .sasConfiguration(sasConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocationAzureBlobArgs].
 */
@PulumiTagMarker
public class LocationAzureBlobArgsBuilder internal constructor() {
    private var accessTier: Output<String>? = null

    private var agentArns: Output<List<String>>? = null

    private var authenticationType: Output<String>? = null

    private var blobType: Output<String>? = null

    private var containerUrl: Output<String>? = null

    private var sasConfiguration: Output<LocationAzureBlobSasConfigurationArgs>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The access tier that you want your objects or files transferred into. Valid values: `HOT`, `COOL` and `ARCHIVE`. Default: `HOT`.
     */
    @JvmName("vvologmxauoliypc")
    public suspend fun accessTier(`value`: Output<String>) {
        this.accessTier = value
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("twgkfnabbhjrruqr")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("mmmjuablfovigywn")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("pixamxjesalsgaat")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value The authentication method DataSync uses to access your Azure Blob Storage. Valid values: `SAS`.
     */
    @JvmName("vpmtrtlqjfgvtepf")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Valid values: `BLOB`. Default: `BLOB`.
     */
    @JvmName("vqhorlxjrbqmqble")
    public suspend fun blobType(`value`: Output<String>) {
        this.blobType = value
    }

    /**
     * @param value The URL of the Azure Blob Storage container involved in your transfer.
     */
    @JvmName("sjlvthmutxynjtoq")
    public suspend fun containerUrl(`value`: Output<String>) {
        this.containerUrl = value
    }

    /**
     * @param value The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
     */
    @JvmName("tmrpirlpbsdkkxox")
    public suspend fun sasConfiguration(`value`: Output<LocationAzureBlobSasConfigurationArgs>) {
        this.sasConfiguration = value
    }

    /**
     * @param value Path segments if you want to limit your transfer to a virtual directory in the container.
     */
    @JvmName("fbdyrbfyiybhccxa")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qsyoejelfksoteyk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The access tier that you want your objects or files transferred into. Valid values: `HOT`, `COOL` and `ARCHIVE`. Default: `HOT`.
     */
    @JvmName("hlrtevuiormhhtko")
    public suspend fun accessTier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("kduudfyjthuapkib")
    public suspend fun agentArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("yimdubigdswkjgmj")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param value The authentication method DataSync uses to access your Azure Blob Storage. Valid values: `SAS`.
     */
    @JvmName("bfeuckieccbgsjoi")
    public suspend fun authenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Valid values: `BLOB`. Default: `BLOB`.
     */
    @JvmName("bhonhcgpumpapyxk")
    public suspend fun blobType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobType = mapped
    }

    /**
     * @param value The URL of the Azure Blob Storage container involved in your transfer.
     */
    @JvmName("agampnubcypacgwv")
    public suspend fun containerUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerUrl = mapped
    }

    /**
     * @param value The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
     */
    @JvmName("bliuluwscjyidhmp")
    public suspend fun sasConfiguration(`value`: LocationAzureBlobSasConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasConfiguration = mapped
    }

    /**
     * @param argument The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
     */
    @JvmName("mjpdlrueqjxhkarn")
    public suspend
    fun sasConfiguration(argument: suspend LocationAzureBlobSasConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LocationAzureBlobSasConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sasConfiguration = mapped
    }

    /**
     * @param value Path segments if you want to limit your transfer to a virtual directory in the container.
     */
    @JvmName("uciqinfseurblkqm")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ukfstjlbyvdrugbk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mfdgsrfgmkvolnir")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocationAzureBlobArgs = LocationAzureBlobArgs(
        accessTier = accessTier,
        agentArns = agentArns,
        authenticationType = authenticationType,
        blobType = blobType,
        containerUrl = containerUrl,
        sasConfiguration = sasConfiguration,
        subdirectory = subdirectory,
        tags = tags,
    )
}
