@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.LocationFsxOntapFileSystemProtocol
import com.pulumi.aws.datasync.kotlin.outputs.LocationFsxOntapFileSystemProtocol.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LocationFsxOntapFileSystem].
 */
@PulumiTagMarker
public class LocationFsxOntapFileSystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocationFsxOntapFileSystemArgs = LocationFsxOntapFileSystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocationFsxOntapFileSystemArgsBuilder.() -> Unit) {
        val builder = LocationFsxOntapFileSystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LocationFsxOntapFileSystem {
        val builtJavaResource =
            com.pulumi.aws.datasync.LocationFsxOntapFileSystem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LocationFsxOntapFileSystem(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS DataSync Location FSx Ontap File System.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationFsxOntapFileSystem;
 * import com.pulumi.aws.datasync.LocationFsxOntapFileSystemArgs;
 * import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolArgs;
 * import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolNfsArgs;
 * import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new LocationFsxOntapFileSystem("test", LocationFsxOntapFileSystemArgs.builder()
 *             .fsxFilesystemArn(aws_fsx_ontap_file_system.test().arn())
 *             .securityGroupArns(aws_security_group.test().arn())
 *             .storageVirtualMachineArn(aws_fsx_ontap_storage_virtual_machine.test().arn())
 *             .protocol(LocationFsxOntapFileSystemProtocolArgs.builder()
 *                 .nfs(LocationFsxOntapFileSystemProtocolNfsArgs.builder()
 *                     .mountOptions(LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs.builder()
 *                         .version("NFS3")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_fsx_ontap_file_system` using the `DataSync-ARN#FSx-ontap-svm-ARN`. For example:
 * ```sh
 *  $ pulumi import aws:datasync/locationFsxOntapFileSystem:LocationFsxOntapFileSystem example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:123456789012:storage-virtual-machine/svm-12345678abcdef123
 * ```
 *
 */
public class LocationFsxOntapFileSystem internal constructor(
    override val javaResource: com.pulumi.aws.datasync.LocationFsxOntapFileSystem,
) : KotlinCustomResource(javaResource, LocationFsxOntapFileSystemMapper) {
    /**
     * ARN of the DataSync Location for the FSx Ontap File System.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * ARN of the FSx Ontap File System.
     */
    public val fsxFilesystemArn: Output<String>
        get() = javaResource.fsxFilesystemArn().applyValue({ args0 -> args0 })

    /**
     * The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
     */
    public val protocol: Output<LocationFsxOntapFileSystemProtocol>
        get() = javaResource.protocol().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The security groups that provide access to your file system's preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     */
    public val securityGroupArns: Output<List<String>>
        get() = javaResource.securityGroupArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ARN of the SVM in your file system where you want to copy data to of from.
     * The following arguments are optional:
     */
    public val storageVirtualMachineArn: Output<String>
        get() = javaResource.storageVirtualMachineArn().applyValue({ args0 -> args0 })

    /**
     * Path to the file share in the SVM where you'll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * URI of the FSx ONTAP file system location
     */
    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object LocationFsxOntapFileSystemMapper : ResourceMapper<LocationFsxOntapFileSystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.LocationFsxOntapFileSystem::class == javaResource::class

    override fun map(javaResource: Resource): LocationFsxOntapFileSystem =
        LocationFsxOntapFileSystem(javaResource as com.pulumi.aws.datasync.LocationFsxOntapFileSystem)
}

/**
 * @see [LocationFsxOntapFileSystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocationFsxOntapFileSystem].
 */
public suspend fun locationFsxOntapFileSystem(
    name: String,
    block: suspend LocationFsxOntapFileSystemResourceBuilder.() -> Unit,
):
    LocationFsxOntapFileSystem {
    val builder = LocationFsxOntapFileSystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocationFsxOntapFileSystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun locationFsxOntapFileSystem(name: String): LocationFsxOntapFileSystem {
    val builder = LocationFsxOntapFileSystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
