@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LocationFsxWindows].
 */
@PulumiTagMarker
public class LocationFsxWindowsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocationFsxWindowsArgs = LocationFsxWindowsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocationFsxWindowsArgsBuilder.() -> Unit) {
        val builder = LocationFsxWindowsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LocationFsxWindows {
        val builtJavaResource = com.pulumi.aws.datasync.LocationFsxWindows(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocationFsxWindows(builtJavaResource)
    }
}

/**
 * Manages an AWS DataSync FSx Windows Location.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationFsxWindows;
 * import com.pulumi.aws.datasync.LocationFsxWindowsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationFsxWindows("example", LocationFsxWindowsArgs.builder()
 *             .fsxFilesystemArn(aws_fsx_windows_file_system.example().arn())
 *             .user("SomeUser")
 *             .password("SuperSecretPassw0rd")
 *             .securityGroupArns(aws_security_group.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_fsx_windows_file_system` using the `DataSync-ARN#FSx-Windows-ARN`. For example:
 * ```sh
 *  $ pulumi import aws:datasync/locationFsxWindows:LocationFsxWindows example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:476956259333:file-system/fs-08e04cd442c1bb94a
 * ```
 *
 */
public class LocationFsxWindows internal constructor(
    override val javaResource: com.pulumi.aws.datasync.LocationFsxWindows,
) : KotlinCustomResource(javaResource, LocationFsxWindowsMapper) {
    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The time that the FSx for Windows location was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The name of the Windows domain that the FSx for Windows server belongs to.
     */
    public val domain: Output<String>?
        get() = javaResource.domain().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Amazon Resource Name (ARN) for the FSx for Windows file system.
     */
    public val fsxFilesystemArn: Output<String>
        get() = javaResource.fsxFilesystemArn().applyValue({ args0 -> args0 })

    /**
     * The password of the user who has the permissions to access files and folders in the FSx for Windows file system.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Windows file system.
     */
    public val securityGroupArns: Output<List<String>>
        get() = javaResource.securityGroupArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Subdirectory to perform actions as source or destination.
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The URL of the FSx for Windows location that was described.
     */
    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })

    /**
     * The user who has the permissions to access files and folders in the FSx for Windows file system.
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object LocationFsxWindowsMapper : ResourceMapper<LocationFsxWindows> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.LocationFsxWindows::class == javaResource::class

    override fun map(javaResource: Resource): LocationFsxWindows = LocationFsxWindows(
        javaResource as
            com.pulumi.aws.datasync.LocationFsxWindows,
    )
}

/**
 * @see [LocationFsxWindows].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocationFsxWindows].
 */
public suspend fun locationFsxWindows(
    name: String,
    block: suspend LocationFsxWindowsResourceBuilder.() -> Unit,
): LocationFsxWindows {
    val builder = LocationFsxWindowsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocationFsxWindows].
 * @param name The _unique_ name of the resulting resource.
 */
public fun locationFsxWindows(name: String): LocationFsxWindows {
    val builder = LocationFsxWindowsResourceBuilder()
    builder.name(name)
    return builder.build()
}
