@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.LocationHdfsNameNode
import com.pulumi.aws.datasync.kotlin.outputs.LocationHdfsQopConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.datasync.kotlin.outputs.LocationHdfsNameNode.Companion.toKotlin as locationHdfsNameNodeToKotlin
import com.pulumi.aws.datasync.kotlin.outputs.LocationHdfsQopConfiguration.Companion.toKotlin as locationHdfsQopConfigurationToKotlin

/**
 * Builder for [LocationHdfs].
 */
@PulumiTagMarker
public class LocationHdfsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocationHdfsArgs = LocationHdfsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocationHdfsArgsBuilder.() -> Unit) {
        val builder = LocationHdfsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LocationHdfs {
        val builtJavaResource = com.pulumi.aws.datasync.LocationHdfs(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocationHdfs(builtJavaResource)
    }
}

/**
 * Manages an HDFS Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationHdfs;
 * import com.pulumi.aws.datasync.LocationHdfsArgs;
 * import com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationHdfs("example", LocationHdfsArgs.builder()
 *             .agentArns(aws_datasync_agent.example().arn())
 *             .authenticationType("SIMPLE")
 *             .simpleUser("example")
 *             .nameNodes(LocationHdfsNameNodeArgs.builder()
 *                 .hostname(aws_instance.example().private_dns())
 *                 .port(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_hdfs` using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/locationHdfs:LocationHdfs example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 *
 */
public class LocationHdfs internal constructor(
    override val javaResource: com.pulumi.aws.datasync.LocationHdfs,
) : KotlinCustomResource(javaResource, LocationHdfsMapper) {
    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     */
    public val agentArns: Output<List<String>>
        get() = javaResource.agentArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
     */
    public val authenticationType: Output<String>?
        get() = javaResource.authenticationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
     */
    public val blockSize: Output<Int>?
        get() = javaResource.blockSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    public val kerberosKeytab: Output<String>?
        get() = javaResource.kerberosKeytab().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The krb5.conf file that contains the Kerberos configuration information. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    public val kerberosKrb5Conf: Output<String>?
        get() = javaResource.kerberosKrb5Conf().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    public val kerberosPrincipal: Output<String>?
        get() = javaResource.kerberosPrincipal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URI of the HDFS cluster's Key Management Server (KMS).
     */
    public val kmsKeyProviderUri: Output<String>?
        get() = javaResource.kmsKeyProviderUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    public val nameNodes: Output<List<LocationHdfsNameNode>>
        get() = javaResource.nameNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    locationHdfsNameNodeToKotlin(args0)
                })
            })
        })

    /**
     * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
     */
    public val qopConfiguration: Output<LocationHdfsQopConfiguration>?
        get() = javaResource.qopConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> locationHdfsQopConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
     */
    public val replicationFactor: Output<Int>?
        get() = javaResource.replicationFactor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
     */
    public val simpleUser: Output<String>?
        get() = javaResource.simpleUser().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
     */
    public val subdirectory: Output<String>?
        get() = javaResource.subdirectory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object LocationHdfsMapper : ResourceMapper<LocationHdfs> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.LocationHdfs::class == javaResource::class

    override fun map(javaResource: Resource): LocationHdfs = LocationHdfs(
        javaResource as
            com.pulumi.aws.datasync.LocationHdfs,
    )
}

/**
 * @see [LocationHdfs].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocationHdfs].
 */
public suspend fun locationHdfs(
    name: String,
    block: suspend LocationHdfsResourceBuilder.() -> Unit,
): LocationHdfs {
    val builder = LocationHdfsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocationHdfs].
 * @param name The _unique_ name of the resulting resource.
 */
public fun locationHdfs(name: String): LocationHdfs {
    val builder = LocationHdfsResourceBuilder()
    builder.name(name)
    return builder.build()
}
