@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationHdfsArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.LocationHdfsNameNodeArgs
import com.pulumi.aws.datasync.kotlin.inputs.LocationHdfsNameNodeArgsBuilder
import com.pulumi.aws.datasync.kotlin.inputs.LocationHdfsQopConfigurationArgs
import com.pulumi.aws.datasync.kotlin.inputs.LocationHdfsQopConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an HDFS Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationHdfs;
 * import com.pulumi.aws.datasync.LocationHdfsArgs;
 * import com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationHdfs("example", LocationHdfsArgs.builder()
 *             .agentArns(aws_datasync_agent.example().arn())
 *             .authenticationType("SIMPLE")
 *             .simpleUser("example")
 *             .nameNodes(LocationHdfsNameNodeArgs.builder()
 *                 .hostname(aws_instance.example().private_dns())
 *                 .port(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_hdfs` using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/locationHdfs:LocationHdfs example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property agentArns A list of DataSync Agent ARNs with which this location will be associated.
 * @property authenticationType The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
 * @property blockSize The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
 * @property kerberosKeytab The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
 * @property kerberosKrb5Conf The krb5.conf file that contains the Kerberos configuration information. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
 * @property kerberosPrincipal The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
 * @property kmsKeyProviderUri The URI of the HDFS cluster's Key Management Server (KMS).
 * @property nameNodes The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
 * @property qopConfiguration The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
 * @property replicationFactor The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
 * @property simpleUser The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
 * @property subdirectory A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LocationHdfsArgs(
    public val agentArns: Output<List<String>>? = null,
    public val authenticationType: Output<String>? = null,
    public val blockSize: Output<Int>? = null,
    public val kerberosKeytab: Output<String>? = null,
    public val kerberosKrb5Conf: Output<String>? = null,
    public val kerberosPrincipal: Output<String>? = null,
    public val kmsKeyProviderUri: Output<String>? = null,
    public val nameNodes: Output<List<LocationHdfsNameNodeArgs>>? = null,
    public val qopConfiguration: Output<LocationHdfsQopConfigurationArgs>? = null,
    public val replicationFactor: Output<Int>? = null,
    public val simpleUser: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationHdfsArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationHdfsArgs =
        com.pulumi.aws.datasync.LocationHdfsArgs.builder()
            .agentArns(agentArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .blockSize(blockSize?.applyValue({ args0 -> args0 }))
            .kerberosKeytab(kerberosKeytab?.applyValue({ args0 -> args0 }))
            .kerberosKrb5Conf(kerberosKrb5Conf?.applyValue({ args0 -> args0 }))
            .kerberosPrincipal(kerberosPrincipal?.applyValue({ args0 -> args0 }))
            .kmsKeyProviderUri(kmsKeyProviderUri?.applyValue({ args0 -> args0 }))
            .nameNodes(
                nameNodes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .qopConfiguration(qopConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicationFactor(replicationFactor?.applyValue({ args0 -> args0 }))
            .simpleUser(simpleUser?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocationHdfsArgs].
 */
@PulumiTagMarker
public class LocationHdfsArgsBuilder internal constructor() {
    private var agentArns: Output<List<String>>? = null

    private var authenticationType: Output<String>? = null

    private var blockSize: Output<Int>? = null

    private var kerberosKeytab: Output<String>? = null

    private var kerberosKrb5Conf: Output<String>? = null

    private var kerberosPrincipal: Output<String>? = null

    private var kmsKeyProviderUri: Output<String>? = null

    private var nameNodes: Output<List<LocationHdfsNameNodeArgs>>? = null

    private var qopConfiguration: Output<LocationHdfsQopConfigurationArgs>? = null

    private var replicationFactor: Output<Int>? = null

    private var simpleUser: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("msgoeubohcwqhfbm")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("wefrqapbwkpaqfxe")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("swijcokytsrjlgbe")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
     */
    @JvmName("xcsvndvswevtdrxo")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
     */
    @JvmName("qxpntkesugvvgkln")
    public suspend fun blockSize(`value`: Output<Int>) {
        this.blockSize = value
    }

    /**
     * @param value The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    @JvmName("thlpjiisqglwjitb")
    public suspend fun kerberosKeytab(`value`: Output<String>) {
        this.kerberosKeytab = value
    }

    /**
     * @param value The krb5.conf file that contains the Kerberos configuration information. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    @JvmName("nxhokfvsnwyqhpue")
    public suspend fun kerberosKrb5Conf(`value`: Output<String>) {
        this.kerberosKrb5Conf = value
    }

    /**
     * @param value The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    @JvmName("xrmpfacypajdcpwu")
    public suspend fun kerberosPrincipal(`value`: Output<String>) {
        this.kerberosPrincipal = value
    }

    /**
     * @param value The URI of the HDFS cluster's Key Management Server (KMS).
     */
    @JvmName("ptwmyrmsmgofppau")
    public suspend fun kmsKeyProviderUri(`value`: Output<String>) {
        this.kmsKeyProviderUri = value
    }

    /**
     * @param value The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    @JvmName("psgbwnbkmwobaxdc")
    public suspend fun nameNodes(`value`: Output<List<LocationHdfsNameNodeArgs>>) {
        this.nameNodes = value
    }

    @JvmName("uekkhuvaqgutxflu")
    public suspend fun nameNodes(vararg values: Output<LocationHdfsNameNodeArgs>) {
        this.nameNodes = Output.all(values.asList())
    }

    /**
     * @param values The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    @JvmName("ymdlgwdyynwncsvx")
    public suspend fun nameNodes(values: List<Output<LocationHdfsNameNodeArgs>>) {
        this.nameNodes = Output.all(values)
    }

    /**
     * @param value The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
     */
    @JvmName("nxkndqxmuoihvflb")
    public suspend fun qopConfiguration(`value`: Output<LocationHdfsQopConfigurationArgs>) {
        this.qopConfiguration = value
    }

    /**
     * @param value The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
     */
    @JvmName("qplrmpiaodlpvhvh")
    public suspend fun replicationFactor(`value`: Output<Int>) {
        this.replicationFactor = value
    }

    /**
     * @param value The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
     */
    @JvmName("hgkjewnvaayqopyg")
    public suspend fun simpleUser(`value`: Output<String>) {
        this.simpleUser = value
    }

    /**
     * @param value A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
     */
    @JvmName("girvvibvgfkguymg")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("atibjnsytnehsegx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("lmgtlcnqhgbbpkiu")
    public suspend fun agentArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("eiksbggsfkhpyjki")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param value The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
     */
    @JvmName("iaftlbldhopnxtlr")
    public suspend fun authenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
     */
    @JvmName("qchlufatgdjawiln")
    public suspend fun blockSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockSize = mapped
    }

    /**
     * @param value The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    @JvmName("nrpvacfbtbeuputc")
    public suspend fun kerberosKeytab(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosKeytab = mapped
    }

    /**
     * @param value The krb5.conf file that contains the Kerberos configuration information. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    @JvmName("rypcibxvbqbpvltn")
    public suspend fun kerberosKrb5Conf(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosKrb5Conf = mapped
    }

    /**
     * @param value The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    @JvmName("iicfqmbxpmgflnvy")
    public suspend fun kerberosPrincipal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosPrincipal = mapped
    }

    /**
     * @param value The URI of the HDFS cluster's Key Management Server (KMS).
     */
    @JvmName("elnckpgooivbjucv")
    public suspend fun kmsKeyProviderUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyProviderUri = mapped
    }

    /**
     * @param value The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    @JvmName("bxiomdrpmthestoi")
    public suspend fun nameNodes(`value`: List<LocationHdfsNameNodeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameNodes = mapped
    }

    /**
     * @param argument The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    @JvmName("fkrtluaiuagcubup")
    public suspend fun nameNodes(argument: List<suspend LocationHdfsNameNodeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LocationHdfsNameNodeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nameNodes = mapped
    }

    /**
     * @param argument The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    @JvmName("tormgsuelhjdgkon")
    public suspend fun nameNodes(
        vararg
        argument: suspend LocationHdfsNameNodeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LocationHdfsNameNodeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nameNodes = mapped
    }

    /**
     * @param argument The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    @JvmName("qexyfocrrbrhvkxr")
    public suspend fun nameNodes(argument: suspend LocationHdfsNameNodeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LocationHdfsNameNodeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nameNodes = mapped
    }

    /**
     * @param values The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    @JvmName("skqhsflcyfnsorhi")
    public suspend fun nameNodes(vararg values: LocationHdfsNameNodeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameNodes = mapped
    }

    /**
     * @param value The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
     */
    @JvmName("lhdqiyiamotaikfw")
    public suspend fun qopConfiguration(`value`: LocationHdfsQopConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qopConfiguration = mapped
    }

    /**
     * @param argument The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
     */
    @JvmName("kuneaubndsqoesqq")
    public suspend
    fun qopConfiguration(argument: suspend LocationHdfsQopConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LocationHdfsQopConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.qopConfiguration = mapped
    }

    /**
     * @param value The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
     */
    @JvmName("lvumubnsgqkwywqq")
    public suspend fun replicationFactor(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationFactor = mapped
    }

    /**
     * @param value The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
     */
    @JvmName("ynqyjdeyhfwkpinw")
    public suspend fun simpleUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simpleUser = mapped
    }

    /**
     * @param value A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
     */
    @JvmName("dbwhpasaberkigvq")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wsuvbdptjfgmmmsx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vcerpbfbowwiyyap")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocationHdfsArgs = LocationHdfsArgs(
        agentArns = agentArns,
        authenticationType = authenticationType,
        blockSize = blockSize,
        kerberosKeytab = kerberosKeytab,
        kerberosKrb5Conf = kerberosKrb5Conf,
        kerberosPrincipal = kerberosPrincipal,
        kmsKeyProviderUri = kmsKeyProviderUri,
        nameNodes = nameNodes,
        qopConfiguration = qopConfiguration,
        replicationFactor = replicationFactor,
        simpleUser = simpleUser,
        subdirectory = subdirectory,
        tags = tags,
    )
}
