@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationSmbArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.LocationSmbMountOptionsArgs
import com.pulumi.aws.datasync.kotlin.inputs.LocationSmbMountOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a SMB Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationSmb;
 * import com.pulumi.aws.datasync.LocationSmbArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationSmb("example", LocationSmbArgs.builder()
 *             .serverHostname("smb.example.com")
 *             .subdirectory("/exported/path")
 *             .user("Guest")
 *             .password("ANotGreatPassword")
 *             .agentArns(aws_datasync_agent.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_smb` using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/locationSmb:LocationSmb example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property agentArns A list of DataSync Agent ARNs with which this location will be associated.
 * @property domain The name of the Windows domain the SMB server belongs to.
 * @property mountOptions Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
 * @property password The password of the user who can mount the share and has file permissions in the SMB.
 * @property serverHostname Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
 * @property subdirectory Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property user The user who can mount the share and has file and folder permissions in the SMB share.
 */
public data class LocationSmbArgs(
    public val agentArns: Output<List<String>>? = null,
    public val domain: Output<String>? = null,
    public val mountOptions: Output<LocationSmbMountOptionsArgs>? = null,
    public val password: Output<String>? = null,
    public val serverHostname: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationSmbArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationSmbArgs =
        com.pulumi.aws.datasync.LocationSmbArgs.builder()
            .agentArns(agentArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .mountOptions(mountOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .password(password?.applyValue({ args0 -> args0 }))
            .serverHostname(serverHostname?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationSmbArgs].
 */
@PulumiTagMarker
public class LocationSmbArgsBuilder internal constructor() {
    private var agentArns: Output<List<String>>? = null

    private var domain: Output<String>? = null

    private var mountOptions: Output<LocationSmbMountOptionsArgs>? = null

    private var password: Output<String>? = null

    private var serverHostname: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var user: Output<String>? = null

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("hyhfeerxgdaedibf")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("whiysstjtuuaxghm")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("xnjtvhrwydxjiwov")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value The name of the Windows domain the SMB server belongs to.
     */
    @JvmName("uctndriaurwdrdsm")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     */
    @JvmName("yrsbcdrkpyplcbia")
    public suspend fun mountOptions(`value`: Output<LocationSmbMountOptionsArgs>) {
        this.mountOptions = value
    }

    /**
     * @param value The password of the user who can mount the share and has file permissions in the SMB.
     */
    @JvmName("rrthhvwjiiuvrmrs")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
     */
    @JvmName("cdojsxjucurprimm")
    public suspend fun serverHostname(`value`: Output<String>) {
        this.serverHostname = value
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     */
    @JvmName("aktjrlwrnpulcjnk")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iyhwvwvgelnwepxe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user who can mount the share and has file and folder permissions in the SMB share.
     */
    @JvmName("xwhchqbmqhwjluqg")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("wjcndigbtgsrrdrv")
    public suspend fun agentArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("fcwulmemnttxghoq")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param value The name of the Windows domain the SMB server belongs to.
     */
    @JvmName("odygamyhuhnlhfbt")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     */
    @JvmName("lqkcsuqxetodmqeg")
    public suspend fun mountOptions(`value`: LocationSmbMountOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param argument Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     */
    @JvmName("ybsaxnvhulnakwdf")
    public suspend fun mountOptions(argument: suspend LocationSmbMountOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LocationSmbMountOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mountOptions = mapped
    }

    /**
     * @param value The password of the user who can mount the share and has file permissions in the SMB.
     */
    @JvmName("pgpbkdufkwusaxkc")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
     */
    @JvmName("pjskwjarvpffgvee")
    public suspend fun serverHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverHostname = mapped
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     */
    @JvmName("hjjwbnefyfexfsmt")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rxtwjxytvrfemvby")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vvneuqlydeenqanc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user who can mount the share and has file and folder permissions in the SMB share.
     */
    @JvmName("dyscqxexxequjlry")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): LocationSmbArgs = LocationSmbArgs(
        agentArns = agentArns,
        domain = domain,
        mountOptions = mountOptions,
        password = password,
        serverHostname = serverHostname,
        subdirectory = subdirectory,
        tags = tags,
        user = user,
    )
}
